/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogBuilder;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.simple.SimpleLoggerContext;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class InternalLoggerContext
extends LoggerContext {
    private final SimpleLoggerContext simpleLoggerContext = new SimpleLoggerContext();
    private static final LoggerConfig LOGGER_CONFIG = new LoggerConfig.RootLogger();

    public InternalLoggerContext() {
        this.setStarted();
    }

    @Override
    protected Logger newInstance(LoggerContext ctx, String name, MessageFactory messageFactory) {
        return new InternalLogger(this, name);
    }

    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        return false;
    }

    private class InternalLogger
    extends Logger {
        private final ExtendedLogger logger;
        private final InternalLoggerContext loggerContext;

        public InternalLogger(InternalLoggerContext loggerContext, String name) {
            super(loggerContext, name);
            this.loggerContext = loggerContext;
            this.logger = InternalLoggerContext.this.simpleLoggerContext.getLogger(name);
        }

        @Override
        public Logger getParent() {
            return null;
        }

        @Override
        public LoggerContext getContext() {
            return this.loggerContext;
        }

        @Override
        public void setLevel(Level level) {
        }

        @Override
        public LoggerConfig get() {
            return LOGGER_CONFIG;
        }

        @Override
        protected boolean requiresLocation() {
            return false;
        }

        @Override
        public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable t) {
        }

        @Override
        protected void log(Level level, Marker marker, String fqcn, StackTraceElement location, Message message, Throwable throwable) {
            this.logger.log(level, marker, message, throwable);
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Throwable t) {
            return this.logger.isEnabled(level, marker, message, t);
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message) {
            return this.logger.isEnabled(level, marker, message);
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Object ... params) {
            return this.logger.isEnabled(level, marker, message, params);
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Object p0) {
            return this.logger.isEnabled(level, marker, message, p0);
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1) {
            return this.logger.isEnabled(level, marker, message, p0, p1);
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
            return this.logger.isEnabled(level, marker, message, p0, p1, p2);
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
            return this.logger.isEnabled(level, marker, message, p0, p1, p2, p3);
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
            return this.logger.isEnabled(level, marker, message, p0, p1, p2, p3, p4);
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
            return this.logger.isEnabled(level, marker, message, p0, p1, p2, p3, p4, p5);
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
            return this.logger.isEnabled(level, marker, message, p0, p1, p2, p3, p4, p5, p6);
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
            return this.logger.isEnabled(level, marker, message, p0, p1, p2, p3, p4, p5, p6, p7);
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
            return this.logger.isEnabled(level, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
            return this.logger.isEnabled(level, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, CharSequence message, Throwable t) {
            return this.logger.isEnabled(level, marker, message, t);
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, Object message, Throwable t) {
            return this.logger.isEnabled(level, marker, message, t);
        }

        @Override
        public boolean isEnabled(Level level, Marker marker, Message message, Throwable t) {
            return this.logger.isEnabled(level, marker, message, t);
        }

        @Override
        public void addAppender(Appender appender) {
        }

        @Override
        public void removeAppender(Appender appender) {
        }

        @Override
        public Map<String, Appender> getAppenders() {
            return Collections.emptyMap();
        }

        @Override
        public Iterator<Filter> getFilters() {
            return Collections.emptyIterator();
        }

        @Override
        public Level getLevel() {
            return this.logger.getLevel();
        }

        @Override
        public int filterCount() {
            return 0;
        }

        @Override
        public void addFilter(Filter filter) {
        }

        @Override
        public boolean isAdditive() {
            return false;
        }

        @Override
        public void setAdditive(boolean additive) {
        }

        @Override
        public LogBuilder atLevel(Level level) {
            return this.logger.atLevel(level);
        }

        @Override
        protected void updateConfiguration(Configuration newConfig) {
        }
    }
}

