/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigDelegate;
import org.apache.logging.log4j.core.async.AsyncWaitStrategyFactory;
import org.apache.logging.log4j.core.config.ConfigurationScheduler;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.CustomLevelConfig;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.config.ReliabilityStrategy;
import org.apache.logging.log4j.core.filter.Filterable;
import org.apache.logging.log4j.core.impl.LogEventFactory;
import org.apache.logging.log4j.core.lookup.ConfigurationStrSubstitutor;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.core.script.ScriptManager;
import org.apache.logging.log4j.core.time.NanoClock;
import org.apache.logging.log4j.core.util.WatchManager;
import org.apache.logging.log4j.plugins.Node;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.spi.recycler.RecyclerFactory;
import org.apache.logging.log4j.util.PropertyEnvironment;

public interface Configuration
extends Filterable {
    public static final Key<Configuration> KEY = new Key<Configuration>(){};
    public static final String CONTEXT_PROPERTIES = "ContextProperties";

    public String getName();

    public LoggerConfig getLoggerConfig(String var1);

    public <T extends Appender> T getAppender(String var1);

    public Map<String, Appender> getAppenders();

    public void addAppender(Appender var1);

    public Map<String, LoggerConfig> getLoggers();

    public void addLoggerAppender(Logger var1, Appender var2);

    public void addLoggerFilter(Logger var1, Filter var2);

    public void setLoggerAdditive(Logger var1, boolean var2);

    public void addLogger(String var1, LoggerConfig var2);

    public void removeLogger(String var1);

    public Map<String, String> getProperties();

    public PropertyEnvironment getContextProperties();

    public LoggerConfig getRootLogger();

    public void addListener(Consumer<Reconfigurable> var1);

    public void removeListener(Consumer<Reconfigurable> var1);

    public StrSubstitutor getStrSubstitutor();

    default public StrSubstitutor getConfigurationStrSubstitutor() {
        StrSubstitutor defaultSubstitutor = this.getStrSubstitutor();
        if (defaultSubstitutor == null) {
            return new ConfigurationStrSubstitutor();
        }
        return new ConfigurationStrSubstitutor(defaultSubstitutor);
    }

    public void createConfiguration(Node var1, LogEvent var2);

    public <T> T getComponent(String var1);

    public <T> Supplier<T> getFactory(Key<T> var1);

    default public <T> T getComponent(Key<T> key) {
        return this.getFactory(key).get();
    }

    public void addComponent(String var1, Object var2);

    public void setAdvertiser(Advertiser var1);

    public Advertiser getAdvertiser();

    public boolean isShutdownHookEnabled();

    public long getShutdownTimeoutMillis();

    public ConfigurationScheduler getScheduler();

    public ConfigurationSource getConfigurationSource();

    public List<CustomLevelConfig> getCustomLevels();

    public ScriptManager getScriptManager();

    public AsyncLoggerConfigDelegate getAsyncLoggerConfigDelegate();

    public AsyncWaitStrategyFactory getAsyncWaitStrategyFactory();

    public WatchManager getWatchManager();

    public ReliabilityStrategy getReliabilityStrategy(LoggerConfig var1);

    public NanoClock getNanoClock();

    public void setNanoClock(NanoClock var1);

    public LoggerContext getLoggerContext();

    default public LogEventFactory getLogEventFactory() {
        return this.getComponent(LogEventFactory.KEY);
    }

    default public RecyclerFactory getRecyclerFactory() {
        return (RecyclerFactory)this.getComponent(Key.forClass(RecyclerFactory.class));
    }
}

