/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.impl.Log4jPropertyKey;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Constants;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.PropertyKey;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ThreadNameCachingStrategy {
    CACHED{

        @Override
        public String getThreadName() {
            String result = THREADLOCAL_NAME.get();
            if (result == null) {
                result = Thread.currentThread().getName();
                THREADLOCAL_NAME.set(result);
            }
            return result;
        }
    }
    ,
    UNCACHED{

        @Override
        public String getThreadName() {
            return Thread.currentThread().getName();
        }
    };

    private static final StatusLogger LOGGER;
    private static final ThreadLocal<String> THREADLOCAL_NAME;
    static final ThreadNameCachingStrategy DEFAULT_STRATEGY;

    abstract String getThreadName();

    public static ThreadNameCachingStrategy create() {
        String name = PropertiesUtil.getProperties().getStringProperty((PropertyKey)Log4jPropertyKey.ASYNC_LOGGER_THREAD_NAME_STRATEGY);
        try {
            ThreadNameCachingStrategy result = name != null ? ThreadNameCachingStrategy.valueOf(name) : DEFAULT_STRATEGY;
            LOGGER.debug("{}={} (user specified {}, default is {})", (Object)Log4jPropertyKey.ASYNC_LOGGER_THREAD_NAME_STRATEGY, (Object)result.name(), (Object)name, (Object)DEFAULT_STRATEGY.name());
            return result;
        }
        catch (Exception ex) {
            LOGGER.debug("Using {}.{}: '{}' not valid: {}", (Object)Log4jPropertyKey.ASYNC_LOGGER_THREAD_NAME_STRATEGY, (Object)DEFAULT_STRATEGY.name(), (Object)name, (Object)ex.toString());
            return DEFAULT_STRATEGY;
        }
    }

    static boolean isAllocatingThreadGetName() {
        if (Constants.JAVA_MAJOR_VERSION == 8) {
            try {
                Pattern javaVersionPattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)_(\\d+)");
                Matcher m = javaVersionPattern.matcher(System.getProperty("java.version"));
                if (m.matches()) {
                    return Integer.parseInt(m.group(3)) == 0 && Integer.parseInt(m.group(4)) < 102;
                }
                return true;
            }
            catch (Exception e) {
                return true;
            }
        }
        return Constants.JAVA_MAJOR_VERSION < 8;
    }

    static {
        LOGGER = StatusLogger.getLogger();
        THREADLOCAL_NAME = new ThreadLocal();
        DEFAULT_STRATEGY = ThreadNameCachingStrategy.isAllocatingThreadGetName() ? CACHED : UNCACHED;
    }
}

