/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jdbc.appender.internal;

import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.jdbc.appender.DataSourceConnectionSource;
import org.apache.logging.log4j.jndi.JndiManager;
import org.apache.logging.log4j.status.StatusLogger;

public final class JndiUtil {
    private static final Logger LOGGER = StatusLogger.getLogger();
    public static final String JNDI_MANAGER_NAME = DataSourceConnectionSource.class.getCanonicalName();

    private JndiUtil() {
    }

    public static DataSource getDataSource(String jndiName) {
        try {
            DataSource dataSource = (DataSource)JndiManager.getDefaultManager((String)JNDI_MANAGER_NAME).lookup(jndiName);
            if (dataSource == null) {
                LOGGER.error("No data source found with JNDI name [" + jndiName + "].");
                return null;
            }
            return dataSource;
        }
        catch (NamingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

