/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jdbc.appender;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.test.junit.LoggerContextRule;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.logging.log4j.jdbc.appender.JdbcRule;
import org.apache.logging.log4j.jdbc.appender.internal.JndiUtil;
import org.apache.logging.log4j.jndi.test.junit.JndiRule;
import org.h2.util.IOUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public abstract class AbstractJdbcAppenderDataSourceTest {
    @Rule
    public final RuleChain rules;
    private final JdbcRule jdbcRule;

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j2.*.JNDI.enableJDBC", "true");
    }

    protected AbstractJdbcAppenderDataSourceTest(JdbcRule jdbcRule) {
        this.rules = RuleChain.emptyRuleChain().around((TestRule)new JndiRule(JndiUtil.JNDI_MANAGER_NAME, "java:/comp/env/jdbc/TestDataSourceAppender", (Object)this.createMockDataSource())).around((TestRule)jdbcRule).around((TestRule)new LoggerContextRule("org/apache/logging/log4j/jdbc/appender/log4j2-data-source.xml"));
        this.jdbcRule = jdbcRule;
    }

    private DataSource createMockDataSource() {
        try {
            DataSource dataSource = (DataSource)Mockito.mock(DataSource.class);
            BDDMockito.given((Object)dataSource.getConnection()).willAnswer((Answer)new Answer<Connection>(){

                public Connection answer(InvocationOnMock invocation) throws Throwable {
                    return AbstractJdbcAppenderDataSourceTest.this.jdbcRule.getConnectionSource().getConnection();
                }
            });
            return dataSource;
        }
        catch (SQLException e) {
            Throwables.rethrow((Throwable)e);
            throw new InternalError("unreachable");
        }
    }

    @Test
    public void testDataSourceConfig() throws Exception {
        try (Connection connection = this.jdbcRule.getConnectionSource().getConnection();){
            Error exception = new Error("Final error massage is fatal!");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (PrintWriter writer = new PrintWriter(outputStream);){
                exception.printStackTrace(writer);
            }
            String stackTrace = outputStream.toString();
            long millis = System.currentTimeMillis();
            Logger logger = LogManager.getLogger((String)(this.getClass().getName() + ".testDataSourceConfig"));
            logger.trace("Data source logged message 01.");
            logger.fatal("Error from data source 02.", (Throwable)exception);
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT * FROM dsLogEntry ORDER BY id");){
                Assert.assertTrue((String)"There should be at least one row.", (boolean)resultSet.next());
                long date = resultSet.getTimestamp("eventDate").getTime();
                Assert.assertTrue((String)"The date should be later than pre-logging (1).", (date >= millis ? 1 : 0) != 0);
                Assert.assertTrue((String)"The date should be earlier than now (1).", (date <= System.currentTimeMillis() ? 1 : 0) != 0);
                Assert.assertEquals((String)"The literal column is not correct (1).", (Object)"Literal Value of Data Source", (Object)resultSet.getString("literalColumn"));
                Assert.assertEquals((String)"The level column is not correct (1).", (Object)"FATAL", (Object)resultSet.getNString("level"));
                Assert.assertEquals((String)"The logger column is not correct (1).", (Object)logger.getName(), (Object)resultSet.getNString("logger"));
                Assert.assertEquals((String)"The message column is not correct (1).", (Object)"Error from data source 02.", (Object)resultSet.getString("message"));
                Assert.assertEquals((String)"The exception column is not correct (1).", (Object)stackTrace, (Object)IOUtils.readStringAndClose((Reader)resultSet.getNClob("exception").getCharacterStream(), (int)-1));
                Assert.assertFalse((String)"There should not be two rows.", (boolean)resultSet.next());
            }
        }
    }
}

