/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.script;

import org.apache.logging.log4j.spi.PropertyComponent;
import org.apache.logging.log4j.util.PropertyKey;

public enum ScriptPropertyKey implements PropertyKey
{
    SCRIPT_ENABLE_LANGUAGES(PropertyComponent.SCRIPT, "enableLanguages");

    private final PropertyComponent component;
    private final String name;
    private final String key;
    private final String systemKey;

    private ScriptPropertyKey(PropertyComponent component, String name) {
        this.component = component;
        this.name = name;
        this.key = component.getName() + "." + name;
        this.systemKey = "log4j2.*." + this.key;
    }

    public static PropertyKey findKey(String component, String name) {
        for (ScriptPropertyKey key : ScriptPropertyKey.values()) {
            if (!key.getComponent().equals(component) || !key.getName().equals(name)) continue;
            return key;
        }
        return null;
    }

    public String getComponent() {
        return this.component.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public String getSystemKey() {
        return this.systemKey;
    }

    public String toString() {
        return this.getKey();
    }

    public static class Constant {
        private static final String DELIM = ".";
        static final String ENABLE_LANGUAGES = "enableLanguages";
        public static final String SCRIPT_ENABLE_LANGUAGES = "log4j2.*.Script.enableLanguages";
    }
}

