/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jul;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.jul.LevelTranslator;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.status.StatusLogger;

public class Log4jBridgeHandler
extends Handler
implements Consumer<Configuration> {
    private static final Logger SLOGGER = StatusLogger.getLogger();
    private static final String FQCN = java.util.logging.Logger.class.getName();
    private static final String UNKNOWN_LOGGER_NAME = "unknown.jul.logger";
    private static final Formatter julFormatter = new SimpleFormatter();
    private boolean doDebugOutput = false;
    private String julSuffixToAppend = null;
    private LoggerContext context;
    private Set<java.util.logging.Logger> julLoggerRefs;

    public static void install(boolean removeHandlersForRootLogger, String suffixToAppend, boolean propagateLevels) {
        java.util.logging.Logger rootLogger = Log4jBridgeHandler.getJulRootLogger();
        if (removeHandlersForRootLogger) {
            for (Handler hdl : rootLogger.getHandlers()) {
                rootLogger.removeHandler(hdl);
            }
        }
        rootLogger.addHandler(new Log4jBridgeHandler(false, suffixToAppend, propagateLevels));
    }

    private static java.util.logging.Logger getJulRootLogger() {
        return java.util.logging.LogManager.getLogManager().getLogger("");
    }

    public Log4jBridgeHandler() {
        java.util.logging.LogManager julLogMgr = java.util.logging.LogManager.getLogManager();
        String className = this.getClass().getName();
        this.init(Boolean.parseBoolean(julLogMgr.getProperty(className + ".sysoutDebug")), julLogMgr.getProperty(className + ".appendSuffix"), Boolean.parseBoolean(julLogMgr.getProperty(className + ".propagateLevels")));
    }

    public Log4jBridgeHandler(boolean debugOutput, String suffixToAppend, boolean propagateLevels) {
        this.init(debugOutput, suffixToAppend, propagateLevels);
    }

    @SuppressFBWarnings(value={"INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE"}, justification="The data is available only in debug mode.")
    protected void init(boolean debugOutput, String suffixToAppend, boolean propagateLevels) {
        this.doDebugOutput = debugOutput;
        if (debugOutput) {
            new Exception("DIAGNOSTIC ONLY (sysout):  Log4jBridgeHandler instance created (" + this + ")").printStackTrace(System.out);
        }
        if (suffixToAppend != null) {
            if (((String)(suffixToAppend = ((String)suffixToAppend).trim())).isEmpty()) {
                suffixToAppend = null;
            } else if (((String)suffixToAppend).charAt(0) != '.') {
                suffixToAppend = "." + (String)suffixToAppend;
            }
        }
        this.julSuffixToAppend = suffixToAppend;
        this.context = LoggerContext.getContext((boolean)false);
        if (propagateLevels) {
            this.context.addConfigurationStartedListener((Consumer)this);
            this.propagateLogLevels(this.context.getConfiguration());
        }
        SLOGGER.debug("Log4jBridgeHandler init. with: suffix='{}', lvlProp={}, instance={}", suffixToAppend, (Object)propagateLevels, (Object)this);
    }

    @Override
    public void close() {
        this.julLoggerRefs = null;
        if (this.context != null) {
            this.context.removeConfigurationStartedListener((Consumer)this);
            this.context = null;
        }
        if (this.doDebugOutput) {
            System.out.println("sysout:  Log4jBridgeHandler close(): " + this);
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (record == null) {
            return;
        }
        Logger log4jLogger = this.getLog4jLogger(record);
        String msg = julFormatter.formatMessage(record);
        Level log4jLevel = LevelTranslator.toLevel(record.getLevel());
        Throwable thrown = record.getThrown();
        if (log4jLogger instanceof ExtendedLogger) {
            try {
                ((ExtendedLogger)log4jLogger).logIfEnabled(FQCN, log4jLevel, null, msg, thrown);
            }
            catch (NoClassDefFoundError e) {
                log4jLogger.warn("Log4jBridgeHandler: ignored exception when calling 'ExtendedLogger': {}", (Object)e.toString());
                log4jLogger.log(log4jLevel, msg, thrown);
            }
        } else {
            log4jLogger.log(log4jLevel, msg, thrown);
        }
    }

    @Override
    public void flush() {
    }

    private Logger getLog4jLogger(LogRecord record) {
        Object name = record.getLoggerName();
        if (name == null) {
            name = UNKNOWN_LOGGER_NAME;
        } else if (this.julSuffixToAppend != null) {
            name = (String)name + this.julSuffixToAppend;
        }
        return LogManager.getLogger((String)name);
    }

    @Override
    public void accept(Configuration configuration) {
        SLOGGER.debug("Log4jBridgeHandler.accept(): {}", (Object)configuration);
        this.propagateLogLevels(configuration);
    }

    private void propagateLogLevels(Configuration config) {
        java.util.logging.Logger julLog;
        SLOGGER.debug("Log4jBridgeHandler.propagateLogLevels(): {}", (Object)config);
        if (this.julLoggerRefs == null) {
            this.julLoggerRefs = new HashSet<java.util.logging.Logger>();
        } else {
            this.julLoggerRefs.clear();
        }
        Map log4jLoggers = config.getLoggers();
        for (LoggerConfig lcfg : log4jLoggers.values()) {
            julLog = java.util.logging.Logger.getLogger(lcfg.getName());
            java.util.logging.Level julLevel = LevelTranslator.toJavaLevel(lcfg.getLevel());
            julLog.setLevel(julLevel);
            this.julLoggerRefs.add(julLog);
        }
        java.util.logging.LogManager julMgr = java.util.logging.LogManager.getLogManager();
        Enumeration<String> en = julMgr.getLoggerNames();
        while (en.hasMoreElements()) {
            julLog = julMgr.getLogger(en.nextElement());
            if (julLog == null || julLog.getLevel() == null || "".equals(julLog.getName()) || log4jLoggers.containsKey(julLog.getName())) continue;
            julLog.setLevel(null);
        }
    }
}

