/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.junit;

import java.lang.reflect.AnnotatedElement;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.LoggerContextAccessor;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.core.test.junit.LoggerContextSource;
import org.apache.logging.log4j.core.test.junit.ReconfigurationPolicy;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.plugins.di.Binding;
import org.apache.logging.log4j.plugins.di.ConfigurableInstanceFactory;
import org.apache.logging.log4j.plugins.di.DI;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.test.junit.TypeBasedParameterResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ExtensionContextException;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.platform.commons.support.AnnotationSupport;

class LoggerContextResolver
extends TypeBasedParameterResolver<LoggerContext>
implements BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private static final String FQCN = LoggerContextResolver.class.getName();
    private static final ExtensionContext.Namespace BASE_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{LoggerContext.class});

    public LoggerContextResolver() {
        super(LoggerContext.class);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        Class testClass = context.getRequiredTestClass();
        AnnotationSupport.findAnnotation((AnnotatedElement)testClass, LoggerContextSource.class).ifPresent(testSource -> LoggerContextResolver.setUpLoggerContext(testSource, context));
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        Class testClass = context.getRequiredTestClass();
        if (AnnotationSupport.isAnnotated((AnnotatedElement)testClass, LoggerContextSource.class)) {
            ExtensionContext.Store testClassStore = context.getStore(BASE_NAMESPACE.append(new Object[]{testClass}));
            LoggerContextAccessor accessor = (LoggerContextAccessor)testClassStore.get(LoggerContextAccessor.class, LoggerContextAccessor.class);
            if (accessor == null) {
                throw new IllegalStateException("Specified @LoggerContextSource but no LoggerContext found for test class " + testClass.getCanonicalName());
            }
            if (testClassStore.get(ReconfigurationPolicy.class, ReconfigurationPolicy.class) == ReconfigurationPolicy.BEFORE_EACH) {
                accessor.getLoggerContext().reconfigure();
            }
        }
        AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestMethod(), LoggerContextSource.class).ifPresent(source -> {
            LoggerContext loggerContext = LoggerContextResolver.setUpLoggerContext(source, context);
            if (source.reconfigure() == ReconfigurationPolicy.BEFORE_EACH) {
                loggerContext.reconfigure();
            }
        });
    }

    public void afterEach(ExtensionContext context) throws Exception {
        ExtensionContext.Store testClassStore;
        Class testClass = context.getRequiredTestClass();
        if (AnnotationSupport.isAnnotated((AnnotatedElement)testClass, LoggerContextSource.class) && (testClassStore = LoggerContextResolver.getTestStore(context)).get(ReconfigurationPolicy.class, ReconfigurationPolicy.class) == ReconfigurationPolicy.AFTER_EACH) {
            ((LoggerContextAccessor)testClassStore.get(LoggerContextAccessor.class, LoggerContextAccessor.class)).getLoggerContext().reconfigure();
        }
    }

    public LoggerContext resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return LoggerContextResolver.getLoggerContext(extensionContext);
    }

    static LoggerContext getLoggerContext(ExtensionContext context) {
        ExtensionContext.Store store = LoggerContextResolver.getTestStore(context);
        LoggerContextAccessor accessor = (LoggerContextAccessor)store.get(LoggerContextAccessor.class, LoggerContextAccessor.class);
        Assertions.assertNotNull((Object)accessor);
        return accessor.getLoggerContext();
    }

    private static ExtensionContext.Store getTestStore(ExtensionContext context) {
        return context.getStore(BASE_NAMESPACE.append(new Object[]{context.getRequiredTestClass()}));
    }

    private static LoggerContext setUpLoggerContext(LoggerContextSource source, ExtensionContext extensionContext) {
        URI configUri;
        Log4jContextFactory loggerContextFactory;
        String displayName = extensionContext.getDisplayName();
        ConfigurableInstanceFactory instanceFactory = DI.createFactory();
        extensionContext.getTestInstance().ifPresent(arg_0 -> ((ConfigurableInstanceFactory)instanceFactory).registerBundle(arg_0));
        Class<? extends ContextSelector> contextSelectorClass = source.selector();
        if (contextSelectorClass != ContextSelector.class) {
            instanceFactory.registerBinding(Binding.from((Key)ContextSelector.KEY).to(instanceFactory.getFactory(contextSelectorClass)));
        }
        DI.initializeFactory((ConfigurableInstanceFactory)instanceFactory);
        if (source.bootstrap()) {
            loggerContextFactory = new Log4jContextFactory(instanceFactory);
            LogManager.setFactory((LoggerContextFactory)loggerContextFactory);
        } else {
            loggerContextFactory = (Log4jContextFactory)LogManager.getFactory();
        }
        Class testClass = extensionContext.getRequiredTestClass();
        ClassLoader classLoader = testClass.getClassLoader();
        Map.Entry<String, ConfigurableInstanceFactory> injectorContext = Map.entry(ConfigurableInstanceFactory.class.getName(), instanceFactory);
        String configLocation = LoggerContextResolver.getConfigLocation(source, extensionContext);
        if (source.v1config()) {
            System.setProperty(ConfigurationFactory.LOG4J1_CONFIGURATION_FILE_PROPERTY.getSystemKey(), configLocation);
            configUri = null;
        } else {
            configUri = NetUtils.toURI((String)configLocation);
        }
        LoggerContext context = loggerContextFactory.getContext(FQCN, classLoader, injectorContext, false, configUri, displayName);
        Assertions.assertNotNull((Object)context, () -> "No LoggerContext created for " + testClass + " and config file " + configLocation);
        ExtensionContext.Store store = LoggerContextResolver.getTestStore(extensionContext);
        store.put(ReconfigurationPolicy.class, (Object)source.reconfigure());
        store.put(LoggerContextAccessor.class, (Object)new ContextHolder(context, source.timeout(), source.unit()));
        return context;
    }

    private static String getConfigLocation(LoggerContextSource source, ExtensionContext extensionContext) {
        String value = source.value();
        if (value.isEmpty()) {
            for (Class clazz = extensionContext.getRequiredTestClass(); clazz != null; clazz = clazz.getSuperclass()) {
                URL url = clazz.getResource(clazz.getSimpleName() + ".xml");
                if (url == null) continue;
                try {
                    return url.toURI().toString();
                }
                catch (URISyntaxException e) {
                    throw new ExtensionContextException("An error occurred accessing the configuration.", (Throwable)e);
                }
            }
            return extensionContext.getRequiredTestClass().getName().replaceAll("[.$]", "/") + ".xml";
        }
        return value;
    }

    private static final class ContextHolder
    implements ExtensionContext.Store.CloseableResource,
    LoggerContextAccessor {
        private final LoggerContext context;
        private final long shutdownTimeout;
        private final TimeUnit unit;

        private ContextHolder(LoggerContext context, long shutdownTimeout, TimeUnit unit) {
            this.context = context;
            this.shutdownTimeout = shutdownTimeout;
            this.unit = unit;
        }

        public LoggerContext getLoggerContext() {
            return this.context;
        }

        public void close() throws Throwable {
            try {
                this.context.stop(this.shutdownTimeout, this.unit);
            }
            finally {
                System.clearProperty(ConfigurationFactory.LOG4J1_EXPERIMENTAL.getSystemKey());
                System.clearProperty(ConfigurationFactory.LOG4J1_CONFIGURATION_FILE_PROPERTY.getSystemKey());
            }
        }
    }
}

