/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.junit;

import java.util.Optional;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.test.junit.ConfigurationFactoryType;
import org.apache.logging.log4j.plugins.di.Binding;
import org.apache.logging.log4j.plugins.di.ConfigurableInstanceFactory;
import org.apache.logging.log4j.plugins.di.DI;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.spi.LoggingSystem;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

class ConfigurationFactoryTypeCallback
implements BeforeAllCallback,
AfterAllCallback {
    ConfigurationFactoryTypeCallback() {
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        AnnotationSupport.findAnnotation((Optional)context.getTestClass(), ConfigurationFactoryType.class).map(ConfigurationFactoryType::value).ifPresent(configurationFactoryType -> {
            ConfigurableInstanceFactory factory = DI.createInitializedFactory();
            factory.registerBinding(Binding.from((Key)ConfigurationFactory.KEY).to(factory.getFactory(configurationFactoryType)));
            Log4jContextFactory contextFactory = (Log4jContextFactory)factory.getInstance(Log4jContextFactory.class);
            LoggingSystem.getInstance().setLoggerContextFactory((LoggerContextFactory)contextFactory);
        });
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (AnnotationSupport.isAnnotated((Optional)context.getTestClass(), ConfigurationFactoryType.class)) {
            LoggingSystem.getInstance().setLoggerContextFactory(null);
        }
    }
}

