/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jackson;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class LevelMixInTest {
    private ObjectMapper log4jObjectMapper;
    private ObjectReader reader;
    private ObjectWriter writer;

    protected abstract ObjectMapper newObjectMapper();

    @BeforeEach
    public void setUp() {
        this.log4jObjectMapper = this.newObjectMapper();
        this.writer = this.log4jObjectMapper.writer();
        this.reader = this.log4jObjectMapper.readerFor(Level.class);
    }

    @Test
    public void testContainer() throws IOException {
        Fixture expected = new Fixture();
        String str = this.writer.writeValueAsString((Object)expected);
        Assertions.assertTrue((boolean)str.contains("DEBUG"));
        ObjectReader fixtureReader = this.log4jObjectMapper.readerFor(Fixture.class);
        Fixture actual = (Fixture)fixtureReader.readValue(str);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNameOnly() throws IOException {
        Level expected = Level.getLevel((String)"DEBUG");
        String str = this.writer.writeValueAsString((Object)expected);
        Assertions.assertTrue((boolean)str.contains("DEBUG"));
        Level actual = (Level)this.reader.readValue(str);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    static class Fixture {
        @JsonProperty
        private final Level level = Level.DEBUG;

        Fixture() {
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Fixture other = (Fixture)obj;
            return Objects.equals(this.level, other.level);
        }

        public int hashCode() {
            return 31 + Objects.hashCode(this.level);
        }
    }
}

