/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di.spi;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.di.Keys;

public class InjectionPoint<T> {
    public static final Key<InjectionPoint<?>> CURRENT_INJECTION_POINT = new Key<InjectionPoint<?>>(){};
    private final Key<T> key;
    private final Collection<String> aliases;
    private final AnnotatedElement element;

    private InjectionPoint(Key<T> key, Collection<String> aliases, AnnotatedElement element) {
        this.key = key;
        this.aliases = aliases;
        this.element = element;
    }

    public Key<T> getKey() {
        return this.key;
    }

    public Collection<String> getAliases() {
        return this.aliases;
    }

    public AnnotatedElement getElement() {
        return this.element;
    }

    public String toString() {
        return "InjectionPoint{key=" + this.key + ", aliases=" + this.aliases + ", element=" + this.element + "}";
    }

    public static <T> InjectionPoint<T> forField(Field field) {
        Key key = Key.forField(field);
        Collection<String> aliases = Keys.getAliases(field);
        return new InjectionPoint(key, aliases, field);
    }

    public static <T> InjectionPoint<T> forParameter(Parameter parameter) {
        Key key = Key.forParameter(parameter);
        Collection<String> aliases = Keys.getAliases(parameter);
        return new InjectionPoint(key, aliases, parameter);
    }

    public static List<InjectionPoint<?>> fromExecutable(Executable executable) {
        return Stream.of(executable.getParameters()).map(InjectionPoint::forParameter).collect(Collectors.toList());
    }
}

