/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.helpers.AbsoluteTimeDateFormat;

public class ISO8601DateFormat
extends AbsoluteTimeDateFormat {
    private static final long serialVersionUID = -759840745298755296L;
    private static long lastTime;
    private static char[] lastTimeString;

    public ISO8601DateFormat() {
    }

    public ISO8601DateFormat(TimeZone timeZone) {
        super(timeZone);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer sbuf, FieldPosition fieldPosition) {
        int millis;
        long now = date.getTime();
        if (now - (long)(millis = (int)(now % 1000L)) != lastTime || lastTimeString[0] == '\u0000') {
            this.calendar.setTime(date);
            int start = sbuf.length();
            int year = this.calendar.get(1);
            sbuf.append(year);
            sbuf.append(switch (this.calendar.get(2)) {
                case 0 -> "-01-";
                case 1 -> "-02-";
                case 2 -> "-03-";
                case 3 -> "-04-";
                case 4 -> "-05-";
                case 5 -> "-06-";
                case 6 -> "-07-";
                case 7 -> "-08-";
                case 8 -> "-09-";
                case 9 -> "-10-";
                case 10 -> "-11-";
                case 11 -> "-12-";
                default -> "-NA-";
            });
            int day = this.calendar.get(5);
            if (day < 10) {
                sbuf.append('0');
            }
            sbuf.append(day);
            sbuf.append(' ');
            int hour = this.calendar.get(11);
            if (hour < 10) {
                sbuf.append('0');
            }
            sbuf.append(hour);
            sbuf.append(':');
            int mins = this.calendar.get(12);
            if (mins < 10) {
                sbuf.append('0');
            }
            sbuf.append(mins);
            sbuf.append(':');
            int secs = this.calendar.get(13);
            if (secs < 10) {
                sbuf.append('0');
            }
            sbuf.append(secs);
            sbuf.append(',');
            sbuf.getChars(start, sbuf.length(), lastTimeString, 0);
            lastTime = now - (long)millis;
        } else {
            sbuf.append(lastTimeString);
        }
        if (millis < 100) {
            sbuf.append('0');
        }
        if (millis < 10) {
            sbuf.append('0');
        }
        sbuf.append(millis);
        return sbuf;
    }

    @Override
    public Date parse(String s, ParsePosition pos) {
        return null;
    }

    static {
        lastTimeString = new char[20];
    }
}

