package org.apache.logging.log4j.web.plugins;

import org.apache.logging.log4j.plugins.model.PluginEntry;
import org.apache.logging.log4j.plugins.model.PluginService;

public class Log4jPlugins extends PluginService {

  private static final PluginEntry[] ENTRIES = new PluginEntry[] {
    PluginEntry.builder()
      .setKey("servlet")
      .setClassName("org.apache.logging.log4j.web.appender.ServletAppender")
      .setName("Servlet")
      .setNamespace("Core")
      .setElementType("appender")
      .setPrintable(true)
      .get(),
    PluginEntry.builder()
      .setKey("web")
      .setClassName("org.apache.logging.log4j.web.WebLookup")
      .setName("web")
      .setNamespace("Lookup")
      .get()
    };
    @Override
    public PluginEntry[] getEntries() { return ENTRIES; }
}
