/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractMarkerMixInTest {
    private ObjectReader reader;
    private ObjectWriter writer;

    protected abstract ObjectMapper newObjectMapper();

    @BeforeEach
    public void setUp() {
        ObjectMapper log4jObjectMapper = this.newObjectMapper();
        this.writer = log4jObjectMapper.writer();
        this.reader = log4jObjectMapper.readerFor(MarkerManager.Log4jMarker.class);
        MarkerManager.clear();
    }

    @Test
    public void testNameOnly() throws IOException {
        Marker expected = MarkerManager.getMarker((String)"A");
        String str = this.writeValueAsString(expected);
        Assertions.assertFalse((boolean)str.contains("parents"));
        Marker actual = (Marker)this.reader.readValue(str);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testOneParent() throws IOException {
        Marker expected = MarkerManager.getMarker((String)"A");
        Marker parent = MarkerManager.getMarker((String)"PARENT_MARKER");
        expected.addParents(new Marker[]{parent});
        String str = this.writeValueAsString(expected);
        Assertions.assertTrue((boolean)str.contains("PARENT_MARKER"));
        Marker actual = (Marker)this.reader.readValue(str);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testTwoParents() throws IOException {
        Marker expected = MarkerManager.getMarker((String)"A");
        Marker parent1 = MarkerManager.getMarker((String)"PARENT_MARKER1");
        Marker parent2 = MarkerManager.getMarker((String)"PARENT_MARKER2");
        expected.addParents(new Marker[]{parent1});
        expected.addParents(new Marker[]{parent2});
        String str = this.writeValueAsString(expected);
        Assertions.assertTrue((boolean)str.contains("PARENT_MARKER1"));
        Assertions.assertTrue((boolean)str.contains("PARENT_MARKER2"));
        Marker actual = (Marker)this.reader.readValue(str);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    private String writeValueAsString(Marker expected) throws JsonProcessingException {
        String str = this.writer.writeValueAsString((Object)expected);
        return str;
    }
}

