/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jackson.xml.layout;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.jackson.AbstractJacksonLayout;
import org.apache.logging.log4j.jackson.xml.layout.XmlJacksonFactory;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginFactory;

@Configurable(elementType="layout", printObject=true)
@Plugin
public final class XmlLayout
extends AbstractJacksonLayout {
    private static final String ROOT_TAG = "Events";

    public static XmlLayout createDefaultLayout() {
        return new XmlLayout(null, false, false, false, false, StandardCharsets.UTF_8, true, false, false, false, null);
    }

    @PluginFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    private XmlLayout(Configuration config, boolean locationInfo, boolean properties, boolean complete, boolean compact, Charset charset, boolean includeStacktrace, boolean stacktraceAsString, boolean includeNullDelimiter, boolean includeTimeMillis, KeyValuePair[] additionalFields) {
        super(config, new XmlJacksonFactory(includeStacktrace, stacktraceAsString).newWriter(locationInfo, properties, compact, includeTimeMillis), charset, compact, complete, false, null, null, includeNullDelimiter, additionalFields);
    }

    protected AbstractJacksonLayout.LogEventWithAdditionalFields createLogEventWithAdditionalFields(LogEvent event, Map<String, String> additionalFieldsMap) {
        return new XmlLogEventWithAdditionalFields(event, additionalFieldsMap);
    }

    public Map<String, String> getContentFormat() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("xsd", "log4j-events.xsd");
        result.put("version", "2.0");
        return result;
    }

    public String getContentType() {
        return "text/xml; charset=" + this.getCharset();
    }

    public byte[] getFooter() {
        if (!this.complete) {
            return null;
        }
        return this.getBytes("</Events>" + this.eol);
    }

    public byte[] getHeader() {
        if (!this.complete) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"1.0\" encoding=\"");
        buf.append(this.getCharset().name());
        buf.append("\"?>");
        buf.append(this.eol);
        buf.append('<');
        buf.append(ROOT_TAG);
        buf.append(" xmlns=\"http://logging.apache.org/log4j/2.0/events\">");
        buf.append(this.eol);
        return buf.toString().getBytes(this.getCharset());
    }

    @JacksonXmlRootElement(namespace="http://logging.apache.org/log4j/2.0/events", localName="Event")
    public static class XmlLogEventWithAdditionalFields
    extends AbstractJacksonLayout.LogEventWithAdditionalFields {
        public XmlLogEventWithAdditionalFields(LogEvent logEvent, Map<String, String> additionalFields) {
            super(logEvent, additionalFields);
        }

        @JsonSerialize(as=LogEvent.class)
        public LogEvent getLogEvent() {
            return super.getLogEvent();
        }
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractJacksonLayout.Builder<B>
    implements org.apache.logging.log4j.plugins.util.Builder<XmlLayout> {
        public Builder() {
            this.setCharset(StandardCharsets.UTF_8);
        }

        public XmlLayout build() {
            return new XmlLayout(this.getConfiguration(), this.isLocationInfo(), this.isProperties(), this.isComplete(), this.isCompact(), this.getCharset(), this.isIncludeStacktrace(), this.isStacktraceAsString(), this.isIncludeNullDelimiter(), this.isIncludeNullDelimiter(), this.getAdditionalFields());
        }
    }
}

