/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.docker;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.lookup.AbstractLookup;
import org.apache.logging.log4j.core.lookup.Lookup;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.docker.model.Container;
import org.apache.logging.log4j.docker.model.Network;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;

@Lookup
@Plugin(value="docker")
public class DockerLookup
extends AbstractLookup {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String DOCKER_URI = "DOCKER_URI";
    private static final String HTTP = "http";
    private final Container container;

    public DockerLookup() {
        String baseUri = System.getenv(DOCKER_URI);
        if (baseUri == null) {
            PropertiesUtil props = PropertiesUtil.getProperties();
            baseUri = props.getStringProperty(DOCKER_URI);
        }
        if (baseUri == null) {
            LOGGER.warn("No Docker URI provided. Docker information is unavailable");
            this.container = null;
            return;
        }
        Container current = null;
        try {
            URL url = new URL(baseUri + "/containers/json");
            if (url.getProtocol().equals(HTTP)) {
                String macAddr = NetUtils.getMacAddressString();
                ObjectMapper objectMapper = new ObjectMapper();
                List containerList = (List)objectMapper.readValue(url, (TypeReference)new TypeReference<List<Container>>(){});
                for (Container container : containerList) {
                    Map<String, Network> networks;
                    if (macAddr != null && container.getNetworkSettings() != null && (networks = container.getNetworkSettings().getNetworks()) != null) {
                        for (Network network : networks.values()) {
                            if (!macAddr.equals(network.getMacAddress())) continue;
                            current = container;
                            break;
                        }
                    }
                    if (current == null) continue;
                    break;
                }
            }
            if (current == null) {
                LOGGER.warn("Unable to determine current container");
            }
        }
        catch (IOException ioe) {
            LOGGER.warn("Unable to read container information: " + ioe.getMessage());
        }
        this.container = current;
    }

    public String lookup(LogEvent event, String key) {
        if (this.container == null) {
            return null;
        }
        switch (key) {
            case "shortContainerId": {
                return this.container.getId().substring(0, 12);
            }
            case "containerId": {
                return this.container.getId();
            }
            case "containerName": {
                if (this.container.getNames().size() > 1) {
                    return this.container.getNames().toString();
                }
                return this.container.getNames().get(0);
            }
            case "shortImageId": {
                return this.container.getImageId().substring(0, 12);
            }
            case "imageId": {
                return this.container.getImageId();
            }
            case "imageName": {
                return this.container.getImage();
            }
        }
        return null;
    }
}

