/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jeromq.appender;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.jeromq.appender.JeroMqManager;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAttribute;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.plugins.validation.constraints.Required;
import org.apache.logging.log4j.util.Strings;

@Configurable(elementType="appender", printObject=true)
@Plugin(value="JeroMQ")
public final class JeroMqAppender
extends AbstractAppender {
    private static final int DEFAULT_BACKLOG = 100;
    private static final int DEFAULT_IVL = 100;
    private static final int DEFAULT_RCV_HWM = 1000;
    private static final int DEFAULT_SND_HWM = 1000;
    private final JeroMqManager manager;
    private final List<String> endpoints;
    private int sendRcFalse;
    private int sendRcTrue;

    private JeroMqAppender(String name, Filter filter, Layout layout, boolean ignoreExceptions, List<String> endpoints, long affinity, long backlog, boolean delayAttachOnConnect, byte[] identity, boolean ipv4Only, long linger, long maxMsgSize, long rcvHwm, long receiveBufferSize, int receiveTimeOut, long reconnectIVL, long reconnectIVLMax, long sendBufferSize, int sendTimeOut, long sndHWM, int tcpKeepAlive, long tcpKeepAliveCount, long tcpKeepAliveIdle, long tcpKeepAliveInterval, boolean xpubVerbose, Property[] properties) {
        super(name, filter, layout, ignoreExceptions, properties);
        this.manager = JeroMqManager.getJeroMqManager(name, affinity, backlog, delayAttachOnConnect, identity, ipv4Only, linger, maxMsgSize, rcvHwm, receiveBufferSize, receiveTimeOut, reconnectIVL, reconnectIVLMax, sendBufferSize, sendTimeOut, sndHWM, tcpKeepAlive, tcpKeepAliveCount, tcpKeepAliveIdle, tcpKeepAliveInterval, xpubVerbose, endpoints);
        this.endpoints = endpoints;
    }

    @PluginFactory
    public static JeroMqAppender createAppender(@Required(message="No name provided for JeroMqAppender") @PluginAttribute String name, @PluginElement Layout layout, @PluginElement Filter filter, @PluginElement Property[] properties, @PluginAttribute boolean ignoreExceptions, @PluginAttribute(defaultLong=0L) long affinity, @PluginAttribute(defaultLong=100L) long backlog, @PluginAttribute boolean delayAttachOnConnect, @PluginAttribute byte[] identity, @PluginAttribute(defaultBoolean=true) boolean ipv4Only, @PluginAttribute(defaultLong=-1L) long linger, @PluginAttribute(defaultLong=-1L) long maxMsgSize, @PluginAttribute(defaultLong=1000L) long rcvHwm, @PluginAttribute(defaultLong=0L) long receiveBufferSize, @PluginAttribute(defaultLong=-1L) int receiveTimeOut, @PluginAttribute(defaultLong=100L) long reconnectIVL, @PluginAttribute(defaultLong=0L) long reconnectIVLMax, @PluginAttribute(defaultLong=0L) long sendBufferSize, @PluginAttribute(defaultLong=-1L) int sendTimeOut, @PluginAttribute(defaultLong=1000L) long sndHwm, @PluginAttribute(defaultInt=-1) int tcpKeepAlive, @PluginAttribute(defaultLong=-1L) long tcpKeepAliveCount, @PluginAttribute(defaultLong=-1L) long tcpKeepAliveIdle, @PluginAttribute(defaultLong=-1L) long tcpKeepAliveInterval, @PluginAttribute boolean xpubVerbose) {
        ArrayList<String> endpoints;
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        if (properties == null) {
            endpoints = new ArrayList<String>(0);
        } else {
            endpoints = new ArrayList(properties.length);
            for (Property property : properties) {
                String value;
                if (!"endpoint".equalsIgnoreCase(property.getName()) || !Strings.isNotEmpty((CharSequence)(value = property.getValue()))) continue;
                endpoints.add(value);
            }
        }
        LOGGER.debug("Creating JeroMqAppender with name={}, filter={}, layout={}, ignoreExceptions={}, endpoints={}", (Object)name, (Object)filter, (Object)layout, (Object)ignoreExceptions, endpoints);
        return new JeroMqAppender(name, filter, layout, ignoreExceptions, endpoints, affinity, backlog, delayAttachOnConnect, identity, ipv4Only, linger, maxMsgSize, rcvHwm, receiveBufferSize, receiveTimeOut, reconnectIVL, reconnectIVLMax, sendBufferSize, sendTimeOut, sndHwm, tcpKeepAlive, tcpKeepAliveCount, tcpKeepAliveIdle, tcpKeepAliveInterval, xpubVerbose, Property.EMPTY_ARRAY);
    }

    public synchronized void append(LogEvent event) {
        Layout layout = this.getLayout();
        byte[] formattedMessage = layout.toByteArray(event);
        if (this.manager.send(this.getLayout().toByteArray(event))) {
            ++this.sendRcTrue;
        } else {
            ++this.sendRcFalse;
            LOGGER.error("Appender {} could not send message {} to JeroMQ {}", (Object)this.getName(), (Object)this.sendRcFalse, (Object)formattedMessage);
        }
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        boolean stopped = super.stop(timeout, timeUnit, false);
        this.setStopped();
        return stopped &= this.manager.stop(timeout, timeUnit);
    }

    int getSendRcFalse() {
        return this.sendRcFalse;
    }

    int getSendRcTrue() {
        return this.sendRcTrue;
    }

    void resetSendRcs() {
        this.sendRcFalse = 0;
        this.sendRcTrue = 0;
    }

    byte[] recv(int timeoutMs) {
        return this.manager.recv(timeoutMs);
    }

    public String toString() {
        return "JeroMqAppender{name=" + this.getName() + ", state=" + this.getState() + ", manager=" + this.manager + ", endpoints=" + this.endpoints + "}";
    }
}

