/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.di.Keys;

public final class InjectionPoint<T> {
    private final Key<T> key;
    private final Collection<String> aliases;
    private final Member member;
    private final AnnotatedElement element;

    private InjectionPoint(Key<T> key, Collection<String> aliases, Member member, AnnotatedElement element) {
        this.key = key;
        this.aliases = aliases;
        this.member = member;
        this.element = element;
    }

    public Key<T> getKey() {
        return this.key;
    }

    public Collection<String> getAliases() {
        return this.aliases;
    }

    public Member getMember() {
        return this.member;
    }

    public AnnotatedElement getElement() {
        return this.element;
    }

    public String toString() {
        return "InjectionPoint{key=" + this.key + ", aliases=" + this.aliases + ", member=" + this.member + ", element=" + this.element + "}";
    }

    public static <T> InjectionPoint<T> forField(Field field) {
        Key key = Key.forField(field);
        Collection<String> aliases = Keys.getAliases(field);
        return new InjectionPoint(key, aliases, field, field);
    }

    public static <T> InjectionPoint<T> forParameter(Executable executable, Parameter parameter) {
        Key key = Key.forParameter(parameter);
        Collection<String> aliases = Keys.getAliases(parameter);
        return new InjectionPoint(key, aliases, executable, parameter);
    }

    public static List<InjectionPoint<?>> fromExecutable(Executable executable) {
        return Stream.of(executable.getParameters()).map(parameter -> InjectionPoint.forParameter(executable, parameter)).collect(Collectors.toList());
    }
}

