/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.smtp.appender;

import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.HtmlLayout;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAttribute;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.plugins.validation.constraints.ValidPort;
import org.apache.logging.log4j.smtp.appender.SmtpManager;

@Configurable(elementType="appender", printObject=true)
@Plugin(value="SMTP")
public final class SmtpAppender
extends AbstractAppender {
    private static final int DEFAULT_BUFFER_SIZE = 512;
    private final SmtpManager manager;

    private SmtpAppender(String name, Filter filter, Layout layout, boolean ignoreExceptions, Property[] properties, SmtpManager manager) {
        super(name, filter, layout, ignoreExceptions, properties);
        this.manager = manager;
    }

    @PluginFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static SmtpAppender createAppender(Configuration config, String name, String to, String cc, String bcc, String from, String replyTo, String subject, String smtpProtocol, String smtpHost, String smtpPortStr, String smtpUsername, String smtpPassword, String smtpDebug, String bufferSizeStr, Layout layout, Filter filter, String ignore) {
        Configuration configuration;
        SmtpManager manager;
        int bufferSize;
        if (name == null) {
            LOGGER.error("No name provided for SmtpAppender");
            return null;
        }
        boolean ignoreExceptions = Booleans.parseBoolean((String)ignore, (boolean)true);
        int smtpPort = AbstractAppender.parseInt((String)smtpPortStr, (int)0);
        boolean isSmtpDebug = Boolean.parseBoolean(smtpDebug);
        int n = bufferSize = bufferSizeStr == null ? 512 : Integer.parseInt(bufferSizeStr);
        if (layout == null) {
            layout = HtmlLayout.createDefaultLayout();
        }
        if (filter == null) {
            filter = ThresholdFilter.createFilter(null, null, null);
        }
        if ((manager = SmtpManager.getSmtpManager(configuration = config != null ? config : new DefaultConfiguration(), to, cc, bcc, from, replyTo, subject, smtpProtocol, smtpHost, smtpPort, smtpUsername, smtpPassword, isSmtpDebug, filter.toString(), bufferSize, null)) == null) {
            return null;
        }
        return new SmtpAppender(name, filter, layout, ignoreExceptions, Property.EMPTY_ARRAY, manager);
    }

    public boolean isFiltered(LogEvent event) {
        boolean filtered = super.isFiltered(event);
        if (filtered) {
            this.manager.add(event);
        }
        return filtered;
    }

    public void append(LogEvent event) {
        this.manager.sendEvents(this.getLayout(), event);
    }

    public static class Builder
    extends AbstractAppender.Builder<Builder>
    implements org.apache.logging.log4j.plugins.util.Builder<SmtpAppender> {
        @PluginAttribute
        private String to;
        @PluginAttribute
        private String cc;
        @PluginAttribute
        private String bcc;
        @PluginAttribute
        private String from;
        @PluginAttribute
        private String replyTo;
        @PluginAttribute
        private String subject;
        @PluginAttribute
        private String smtpProtocol = "smtp";
        @PluginAttribute
        private String smtpHost;
        @PluginAttribute
        @ValidPort
        private int smtpPort;
        @PluginAttribute
        private String smtpUsername;
        @PluginAttribute(sensitive=true)
        private String smtpPassword;
        @PluginAttribute
        private boolean smtpDebug;
        @PluginAttribute
        private int bufferSize = 512;
        @PluginElement(value="SSL")
        private SslConfiguration sslConfiguration;

        public Builder setTo(String to) {
            this.to = to;
            return this;
        }

        public Builder setCc(String cc) {
            this.cc = cc;
            return this;
        }

        public Builder setBcc(String bcc) {
            this.bcc = bcc;
            return this;
        }

        public Builder setFrom(String from) {
            this.from = from;
            return this;
        }

        public Builder setReplyTo(String replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public Builder setSubject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder setSmtpProtocol(String smtpProtocol) {
            this.smtpProtocol = smtpProtocol;
            return this;
        }

        public Builder setSmtpHost(String smtpHost) {
            this.smtpHost = smtpHost;
            return this;
        }

        public Builder setSmtpPort(int smtpPort) {
            this.smtpPort = smtpPort;
            return this;
        }

        public Builder setSmtpUsername(String smtpUsername) {
            this.smtpUsername = smtpUsername;
            return this;
        }

        public Builder setSmtpPassword(String smtpPassword) {
            this.smtpPassword = smtpPassword;
            return this;
        }

        public Builder setSmtpDebug(boolean smtpDebug) {
            this.smtpDebug = smtpDebug;
            return this;
        }

        public Builder setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder setSslConfiguration(SslConfiguration sslConfiguration) {
            this.sslConfiguration = sslConfiguration;
            return this;
        }

        public Builder setLayout(Layout layout) {
            return (Builder)super.setLayout(layout);
        }

        public Builder setFilter(Filter filter) {
            return (Builder)super.setFilter(filter);
        }

        public SmtpAppender build() {
            if (this.getLayout() == null) {
                this.setLayout((Layout)HtmlLayout.createDefaultLayout());
            }
            if (this.getFilter() == null) {
                this.setFilter((Filter)ThresholdFilter.createFilter(null, null, null));
            }
            SmtpManager smtpManager = SmtpManager.getSmtpManager(this.getConfiguration(), this.to, this.cc, this.bcc, this.from, this.replyTo, this.subject, this.smtpProtocol, this.smtpHost, this.smtpPort, this.smtpUsername, this.smtpPassword, this.smtpDebug, this.getFilter().toString(), this.bufferSize, this.sslConfiguration);
            return new SmtpAppender(this.getName(), this.getFilter(), this.getLayout(), this.isIgnoreExceptions(), this.getPropertyArray(), smtpManager);
        }
    }
}

