/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.test.validation;

import java.util.Objects;
import org.apache.logging.log4j.plugins.Namespace;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.plugins.validation.constraints.Required;

@Namespace(value="Test")
@Plugin(value="Validator")
public class ValidatingPlugin {
    private final String name;

    public ValidatingPlugin(String name) {
        this.name = Objects.requireNonNull(name, "name");
    }

    public String getName() {
        return this.name;
    }

    @PluginFactory
    public static ValidatingPlugin newValidatingPlugin(@Required(message="The name given by the factory is null") String name) {
        return new ValidatingPlugin(name);
    }

    @PluginFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.plugins.util.Builder<ValidatingPlugin> {
        @PluginBuilderAttribute
        @Required(message="The name given by the builder is null")
        private String name;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public ValidatingPlugin build() {
            return new ValidatingPlugin(this.name);
        }
    }
}

