/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.kafka.appender;

import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.kafka.appender.KafkaManager;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAttribute;
import org.apache.logging.log4j.plugins.PluginFactory;

@Configurable(elementType="appender", printObject=true)
@Plugin(value="Kafka")
public final class KafkaAppender
extends AbstractAppender {
    private static final String[] KAFKA_CLIENT_PACKAGES = new String[]{"org.apache.kafka.common", "org.apache.kafka.clients"};
    private final Integer retryCount;
    private final KafkaManager manager;

    private static boolean isRecursive(LogEvent event) {
        return Stream.of(KAFKA_CLIENT_PACKAGES).anyMatch(prefix -> event.getLoggerName().startsWith((String)prefix));
    }

    @PluginFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    private KafkaAppender(String name, Layout layout, Filter filter, boolean ignoreExceptions, KafkaManager manager, Property[] properties, int retryCount) {
        super(name, filter, layout, ignoreExceptions, properties);
        this.manager = Objects.requireNonNull(manager, "manager");
        this.retryCount = retryCount;
    }

    public void append(LogEvent event) {
        if (event.getLoggerName() != null && KafkaAppender.isRecursive(event)) {
            LOGGER.warn("Recursive logging from [{}] for appender [{}].", (Object)event.getLoggerName(), (Object)this.getName());
        } else {
            try {
                this.tryAppend(event);
            }
            catch (Exception e) {
                if (this.retryCount != null) {
                    for (int currentRetryAttempt = 0; currentRetryAttempt < this.retryCount; ++currentRetryAttempt) {
                        try {
                            this.tryAppend(event);
                            break;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                }
                this.error("Unable to write to Kafka in appender [" + this.getName() + "]", event, e);
            }
        }
    }

    public void start() {
        super.start();
        this.manager.startup();
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        boolean stopped = super.stop(timeout, timeUnit, false);
        this.setStopped();
        return stopped &= this.manager.stop(timeout, timeUnit);
    }

    public String toString() {
        return "KafkaAppender{name=" + this.getName() + ", state=" + this.getState() + ", topic=" + this.manager.getTopic() + "}";
    }

    private void tryAppend(LogEvent event) throws ExecutionException, InterruptedException, TimeoutException {
        this.manager.send(this.getLayout().toByteArray(event), event.getTimeMillis());
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.plugins.util.Builder<KafkaAppender> {
        @PluginAttribute
        private int retryCount;
        @PluginAttribute
        private String topic;
        @PluginAttribute
        private String key;
        @PluginAttribute(defaultBoolean=true)
        private boolean syncSend;
        @PluginAttribute(defaultBoolean=true)
        private boolean sendEventTimestamp;

        public KafkaAppender build() {
            Layout layout = this.getLayout();
            if (layout == null) {
                LOGGER.error("No layout provided for KafkaAppender");
                return null;
            }
            KafkaManager kafkaManager = KafkaManager.getManager(this.getConfiguration().getLoggerContext(), this.getName(), this.topic, this.syncSend, this.sendEventTimestamp, this.getPropertyArray(), this.key);
            return new KafkaAppender(this.getName(), layout, this.getFilter(), this.isIgnoreExceptions(), kafkaManager, this.getPropertyArray(), this.getRetryCount());
        }

        public Integer getRetryCount() {
            Integer intRetryCount = null;
            try {
                intRetryCount = this.retryCount;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return intRetryCount;
        }

        public String getTopic() {
            return this.topic;
        }

        public boolean isSendEventTimestamp() {
            return this.sendEventTimestamp;
        }

        public boolean isSyncSend() {
            return this.syncSend;
        }

        public B setKey(String key) {
            this.key = key;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setRetryCount(int retryCount) {
            this.retryCount = retryCount;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setSendEventTimestamp(boolean sendEventTimestamp) {
            this.sendEventTimestamp = sendEventTimestamp;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setSyncSend(boolean syncSend) {
            this.syncSend = syncSend;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setTopic(String topic) {
            this.topic = topic;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

