/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.util.LowLevelLogUtil;
import org.apache.logging.log4j.util.PropertySource;
import org.apache.logging.log4j.util.Strings;

public abstract class ContextAwarePropertySource
implements PropertySource {
    protected final Map<String, Properties> propertiesMap;
    private final String contextName;
    private boolean includeInvalid;

    public ContextAwarePropertySource(Properties properties, String contextName, boolean includeInvalid) {
        this.propertiesMap = properties != null ? this.parseProperties(properties, contextName, includeInvalid) : new ConcurrentHashMap<String, Properties>();
        this.contextName = contextName;
        this.includeInvalid = includeInvalid;
    }

    public ContextAwarePropertySource(Map<String, String> properties) {
        this.propertiesMap = this.parseProperties(properties);
        this.contextName = "*";
        this.includeInvalid = false;
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.getPropertyNames("*");
    }

    public Collection<String> getPropertyNames(String contextName) {
        Properties properties = this.getPropertiesMap().get(contextName);
        return properties != null ? properties.stringPropertyNames() : Collections.emptyList();
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty("*", key);
    }

    public String getProperty(String contextName, String key) {
        String value;
        Properties properties = this.getPropertiesMap().get(contextName);
        String string = value = properties != null ? properties.getProperty(key) : null;
        if (Strings.isEmpty(value)) {
            return null;
        }
        return value;
    }

    @Override
    public boolean containsProperty(String key) {
        return this.containsProperty("*", key);
    }

    public boolean containsProperty(String contextName, String key) {
        Map<String, Properties> propertiesMap = this.getPropertiesMap();
        Properties properties = propertiesMap.get(contextName);
        if (properties != null) {
            String value = properties.getProperty(key);
            return Strings.isNotEmpty(value);
        }
        return false;
    }

    public Map<String, Properties> getPropertiesMap() {
        return this.propertiesMap;
    }

    protected Map<String, Properties> parseProperties(Map<String, String> properties) {
        ConcurrentHashMap<String, Properties> propertiesMap = new ConcurrentHashMap<String, Properties>();
        for (String propName : properties.keySet()) {
            if (!propName.startsWith("log4j2.")) continue;
            this.storeProperty(propertiesMap, propName, properties.get(propName));
        }
        return propertiesMap;
    }

    protected Map<String, Properties> parseProperties(Properties properties) {
        return this.parseProperties(properties, this.contextName, this.includeInvalid);
    }

    protected Map<String, Properties> parseProperties(Properties properties, String contextName, boolean includeInvalid) {
        ConcurrentHashMap<String, Properties> propertiesMap = new ConcurrentHashMap<String, Properties>();
        if (contextName == null || contextName.equals("*")) {
            for (String propertyName : properties.stringPropertyNames()) {
                Properties props;
                String propName = PropertySource.Util.resolveKey(propertyName);
                if (propName.startsWith("log4j2.")) {
                    this.storeProperty(propertiesMap, propName, properties.getProperty(propertyName));
                    continue;
                }
                if (propName.startsWith("log4j") || propName.startsWith("log4j1")) {
                    props = (Properties)propertiesMap.get("*");
                    if (props == null) {
                        props = new Properties();
                        propertiesMap.put("*", props);
                    }
                    props.setProperty(propName, properties.getProperty(propertyName));
                    continue;
                }
                if (includeInvalid) {
                    props = (Properties)propertiesMap.get("*");
                    if (props == null) {
                        props = new Properties();
                        propertiesMap.put("*", props);
                    }
                    props.setProperty(propName, properties.getProperty(propertyName));
                    continue;
                }
                LowLevelLogUtil.log("Key " + propName + " is invalid. Log4j properties must be in the form \"log4j2.{contextName}.{componentName}.{key}\"");
            }
        } else {
            for (String propName : properties.stringPropertyNames()) {
                if (!propName.startsWith("log4j2.")) {
                    Properties props = (Properties)propertiesMap.get(contextName);
                    if (props == null) {
                        props = new Properties();
                        propertiesMap.put(contextName, props);
                    }
                    props.put(propName, properties.getProperty(propName));
                    continue;
                }
                LowLevelLogUtil.log("Invalid key " + propName + " for context properties");
            }
        }
        return propertiesMap;
    }

    private void storeProperty(Map<String, Properties> propertiesMap, String propName, String value) {
        if (propName == null || value == null) {
            return;
        }
        List<CharSequence> tokens = PropertySource.Util.getTokens(propName);
        if (tokens.size() < 4) {
            LowLevelLogUtil.log("Key " + propName + " is invalid. Log4j properties must be in the form \"log4j2.{contextName}.{componentName}.{key}\"");
            return;
        }
        String name = tokens.get(1).toString();
        Properties props = propertiesMap.get(name);
        if (props == null) {
            props = new Properties();
            propertiesMap.put(name, props);
        }
        String key = PropertySource.Util.join(tokens.subList(2, tokens.size())).toString();
        props.setProperty(key, value);
    }
}

