/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.lookup.Lookup;
import org.apache.logging.log4j.core.lookup.MapLookup;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.util.Lazy;

@Lookup
@Plugin(value="jvmrunargs")
public class JmxRuntimeInputArgumentsLookup
extends MapLookup {
    private static final Lazy<JmxRuntimeInputArgumentsLookup> INSTANCE = Lazy.lazy(() -> {
        List<String> argsList = ManagementFactory.getRuntimeMXBean().getInputArguments();
        return new JmxRuntimeInputArgumentsLookup(MapLookup.toMap(argsList));
    });

    @PluginFactory
    public static JmxRuntimeInputArgumentsLookup getInstance() {
        return (JmxRuntimeInputArgumentsLookup)INSTANCE.value();
    }

    public JmxRuntimeInputArgumentsLookup() {
    }

    public JmxRuntimeInputArgumentsLookup(Map<String, String> map) {
        super(map);
    }

    @Override
    public String lookup(LogEvent event, String key) {
        return this.lookup(key);
    }

    @Override
    public String lookup(String key) {
        if (key == null) {
            return null;
        }
        Map<String, String> map = this.getMap();
        return map == null ? null : map.get(key);
    }
}

