/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.core.impl.ContextDataInjectorFactory;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Inject;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAttribute;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StringMap;

@Configurable(elementType="filter", printObject=true)
@Plugin
@PerformanceSensitive(value={"allocation"})
public final class DynamicThresholdFilter
extends AbstractFilter {
    private final Level defaultThreshold;
    private final String key;
    private final ContextDataInjector injector;
    private final Map<String, Level> levelMap;

    @Deprecated(since="3.0.0", forRemoval=true)
    public static DynamicThresholdFilter createFilter(String key, KeyValuePair[] pairs, Level defaultThreshold, Filter.Result onMatch, Filter.Result onMismatch) {
        return ((Builder)((Builder)DynamicThresholdFilter.newBuilder().setKey(key).setPairs(pairs).setDefaultThreshold(defaultThreshold).setOnMatch(onMatch)).setOnMismatch(onMismatch)).setContextDataInjector(ContextDataInjectorFactory.createInjector()).get();
    }

    @PluginFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    private DynamicThresholdFilter(String key, Map<String, Level> pairs, Level defaultLevel, Filter.Result onMatch, Filter.Result onMismatch, ContextDataInjector injector) {
        super(onMatch, onMismatch);
        StringMap map = ContextDataFactory.createContextData();
        LOGGER.debug("Successfully initialized ContextDataFactory by retrieving the context data with {} entries", (Object)map.size());
        Objects.requireNonNull(key, "key cannot be null");
        this.key = key;
        this.levelMap = pairs;
        this.defaultThreshold = defaultLevel;
        this.injector = injector;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DynamicThresholdFilter other = (DynamicThresholdFilter)obj;
        if (this.defaultThreshold == null ? other.defaultThreshold != null : !this.defaultThreshold.equals((Object)other.defaultThreshold)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.levelMap == null ? other.levelMap != null : !this.levelMap.equals(other.levelMap));
    }

    private Filter.Result filter(Level level, ReadOnlyStringMap contextMap) {
        String value = (String)contextMap.getValue(this.key);
        if (value != null) {
            Level ctxLevel = this.levelMap.get(value);
            if (ctxLevel == null) {
                ctxLevel = this.defaultThreshold;
            }
            return level.isMoreSpecificThan(ctxLevel) ? this.onMatch : this.onMismatch;
        }
        return Filter.Result.NEUTRAL;
    }

    @Override
    public Filter.Result filter(LogEvent event) {
        return this.filter(event.getLevel(), event.getContextData());
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        return this.filter(level, this.currentContextData());
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        return this.filter(level, this.currentContextData());
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        return this.filter(level, this.currentContextData());
    }

    private ReadOnlyStringMap currentContextData() {
        return this.injector.rawContextData();
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0) {
        return this.filter(level, this.currentContextData());
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1) {
        return this.filter(level, this.currentContextData());
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2) {
        return this.filter(level, this.currentContextData());
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3) {
        return this.filter(level, this.currentContextData());
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return this.filter(level, this.currentContextData());
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return this.filter(level, this.currentContextData());
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return this.filter(level, this.currentContextData());
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return this.filter(level, this.currentContextData());
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return this.filter(level, this.currentContextData());
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return this.filter(level, this.currentContextData());
    }

    public String getKey() {
        return this.key;
    }

    public Map<String, Level> getLevelMap() {
        return this.levelMap;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.defaultThreshold == null ? 0 : this.defaultThreshold.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.levelMap == null ? 0 : this.levelMap.hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("key=").append(this.key);
        sb.append(", default=").append(this.defaultThreshold);
        if (this.levelMap.size() > 0) {
            sb.append('{');
            boolean first = true;
            for (Map.Entry<String, Level> entry : this.levelMap.entrySet()) {
                if (!first) {
                    sb.append(", ");
                    first = false;
                }
                sb.append(entry.getKey()).append('=').append(entry.getValue());
            }
            sb.append('}');
        }
        return sb.toString();
    }

    public static class Builder
    extends AbstractFilter.AbstractFilterBuilder<Builder>
    implements Supplier<DynamicThresholdFilter> {
        private String key;
        private KeyValuePair[] pairs;
        private Level defaultThreshold;
        private ContextDataInjector contextDataInjector;

        public Builder setKey(@PluginAttribute String key) {
            this.key = key;
            return this;
        }

        public Builder setPairs(@PluginElement KeyValuePair[] pairs) {
            this.pairs = pairs;
            return this;
        }

        public Builder setDefaultThreshold(@PluginAttribute Level defaultThreshold) {
            this.defaultThreshold = defaultThreshold;
            return this;
        }

        @Inject
        public Builder setContextDataInjector(ContextDataInjector contextDataInjector) {
            this.contextDataInjector = contextDataInjector;
            return this;
        }

        @Override
        public DynamicThresholdFilter get() {
            if (this.contextDataInjector == null) {
                this.contextDataInjector = ContextDataInjectorFactory.createInjector();
            }
            if (this.defaultThreshold == null) {
                this.defaultThreshold = Level.ERROR;
            }
            Map<String, Level> map = Stream.of(this.pairs).collect(Collectors.toMap(KeyValuePair::getKey, pair -> Level.toLevel((String)pair.getValue())));
            return new DynamicThresholdFilter(this.key, map, this.defaultThreshold, this.getOnMatch(), this.getOnMismatch(), this.contextDataInjector);
        }
    }
}

