/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugin.processor;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Namespace;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAliases;
import org.apache.logging.log4j.plugins.model.PluginEntry;
import org.apache.logging.log4j.util.Strings;

@SupportedAnnotationTypes(value={"org.apache.logging.log4j.plugins.*", "org.apache.logging.log4j.core.config.plugins.*"})
public class PluginProcessor
extends AbstractProcessor {
    private static final String SERVICE_FILE_NAME = "META-INF/services/org.apache.logging.log4j.plugins.model.PluginService";

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Map<String, String> options = this.processingEnv.getOptions();
        String packageName = options.get("pluginPackage");
        Messager messager = this.processingEnv.getMessager();
        messager.printMessage(Diagnostic.Kind.NOTE, "Processing Log4j annotations");
        try {
            Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(Plugin.class);
            if (elements.isEmpty()) {
                messager.printMessage(Diagnostic.Kind.NOTE, "No elements to process");
                return false;
            }
            messager.printMessage(Diagnostic.Kind.NOTE, "Retrieved " + elements.size() + " Plugin elements");
            ArrayList<PluginEntryMirror> list = new ArrayList<PluginEntryMirror>();
            packageName = this.collectPlugins(packageName, elements, list);
            this.writeClassFile(packageName, list);
            this.writeServiceFile(packageName);
            messager.printMessage(Diagnostic.Kind.NOTE, "Annotations processed");
        }
        catch (Exception ex) {
            this.error(ex.getMessage());
        }
        return false;
    }

    private void error(CharSequence message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message);
    }

    private String collectPlugins(String packageName, Iterable<? extends Element> elements, List<PluginEntryMirror> list) {
        boolean calculatePackage = packageName == null;
        Elements elementUtils = this.processingEnv.getElementUtils();
        PluginElementVisitor pluginVisitor = new PluginElementVisitor(elementUtils);
        PluginAliasesElementVisitor pluginAliasesVisitor = new PluginAliasesElementVisitor(elementUtils);
        for (Element element : elements) {
            Plugin plugin = element.getAnnotation(Plugin.class);
            if (plugin == null) continue;
            PluginEntryMirror entry = element.accept(pluginVisitor, plugin);
            list.add(entry);
            if (calculatePackage) {
                packageName = this.calculatePackage(elementUtils, element, packageName);
            }
            list.addAll(element.accept(pluginAliasesVisitor, plugin));
        }
        return packageName;
    }

    private String calculatePackage(Elements elements, Element element, String packageName) {
        Name name = elements.getPackageOf(element).getQualifiedName();
        if (name == null) {
            return null;
        }
        String pkgName = name.toString();
        if (packageName == null) {
            return pkgName;
        }
        if (pkgName.length() == packageName.length()) {
            return packageName;
        }
        if (pkgName.length() < packageName.length() && packageName.startsWith(pkgName)) {
            return pkgName;
        }
        return this.commonPrefix(pkgName, packageName);
    }

    private void writeServiceFile(String pkgName) throws IOException {
        FileObject fileObject = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", SERVICE_FILE_NAME, new Element[0]);
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(fileObject.openOutputStream(), StandardCharsets.UTF_8)));){
            writer.println(this.createFqcn(pkgName));
        }
    }

    private void writeClassFile(String pkg, List<PluginEntryMirror> list) {
        String fqcn = this.createFqcn(pkg);
        try (PrintWriter writer = this.createSourceFile(fqcn);){
            writer.println("package " + pkg + ".plugins;");
            writer.println("");
            writer.println("import org.apache.logging.log4j.plugins.model.PluginEntry;");
            writer.println("import org.apache.logging.log4j.plugins.model.PluginService;");
            writer.println("");
            writer.println("public class Log4jPlugins extends PluginService {");
            writer.println("");
            writer.println("  private static final PluginEntry[] ENTRIES = new PluginEntry[] {");
            int max = list.size() - 1;
            for (int i = 0; i < list.size(); ++i) {
                PluginEntryMirror mirror = list.get(i);
                PluginEntry entry = mirror.entry;
                writer.println("    PluginEntry.builder()");
                writer.println(String.format("      .setKey(\"%s\")", entry.getKey()));
                writer.println(String.format("      .setClassName(\"%s\")", entry.getClassName()));
                writer.println(String.format("      .setName(\"%s\")", entry.getName()));
                writer.println(String.format("      .setNamespace(\"%s\")", entry.getNamespace()));
                String elementType = entry.getElementType();
                if (Strings.isNotEmpty((CharSequence)elementType)) {
                    writer.println(String.format("      .setElementType(\"%s\")", elementType));
                }
                if (entry.isPrintable()) {
                    writer.println("      .setPrintable(true)");
                }
                if (entry.isDeferChildren()) {
                    writer.println("      .setDeferChildren(true)");
                }
                writer.println("      .get()" + (i < max ? "," : ""));
            }
            writer.println("    };");
            writer.println("    @Override");
            writer.println("    public PluginEntry[] getEntries() { return ENTRIES; }");
            writer.println("}");
        }
    }

    private PrintWriter createSourceFile(String fqcn) {
        try {
            JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(fqcn, new Element[0]);
            return new PrintWriter(sourceFile.openWriter());
        }
        catch (IOException e) {
            throw new LoggingException("Unable to create Plugin Service Class " + fqcn, (Throwable)e);
        }
    }

    private String createFqcn(String packageName) {
        return packageName + ".plugins.Log4jPlugins";
    }

    private static String getNamespace(TypeElement e) {
        return Optional.ofNullable(e.getAnnotation(Namespace.class)).map(Namespace::value).orElseGet(() -> e.getAnnotationMirrors().stream().flatMap(annotationMirror -> annotationMirror.getAnnotationType().asElement().getAnnotationMirrors().stream()).filter(annotationMirror -> annotationMirror.getAnnotationType().asElement().getSimpleName().contentEquals(Namespace.class.getSimpleName())).flatMap(annotationMirror -> annotationMirror.getElementValues().values().stream().map(AnnotationValue::getValue).map(Objects::toString)).findFirst().orElse(""));
    }

    private String commonPrefix(String str1, String str2) {
        int minLength = Math.min(str1.length(), str2.length());
        for (int i = 0; i < minLength; ++i) {
            if (str1.charAt(i) == str2.charAt(i)) continue;
            if (i > 1 && str1.charAt(i - 1) == '.') {
                return str1.substring(0, i - 1);
            }
            return str1.substring(0, i);
        }
        return str1.substring(0, minLength);
    }

    private static final class PluginAliasesElementVisitor
    extends SimpleElementVisitor8<Collection<PluginEntryMirror>, Plugin> {
        private final Elements elements;

        private PluginAliasesElementVisitor(Elements elements) {
            super(Collections.emptyList());
            this.elements = elements;
        }

        @Override
        public Collection<PluginEntryMirror> visitType(TypeElement e, Plugin plugin) {
            PluginAliases aliases = e.getAnnotation(PluginAliases.class);
            if (aliases == null) {
                return (Collection)this.DEFAULT_VALUE;
            }
            String name = plugin.value();
            if (name.isEmpty()) {
                name = e.getSimpleName().toString();
            }
            PluginEntry.Builder builder = PluginEntry.builder().setName(name).setClassName(this.elements.getBinaryName(e).toString());
            Configurable configurable = e.getAnnotation(Configurable.class);
            if (configurable != null) {
                builder.setNamespace("Core").setElementType(configurable.elementType().isEmpty() ? name : configurable.elementType()).setDeferChildren(configurable.deferChildren()).setPrintable(configurable.printObject());
            } else {
                builder.setNamespace(PluginProcessor.getNamespace(e));
            }
            ArrayList<PluginEntryMirror> entries = new ArrayList<PluginEntryMirror>(aliases.value().length);
            for (String alias : aliases.value()) {
                PluginEntry entry = builder.setKey(alias.toLowerCase(Locale.ROOT)).get();
                entries.add(new PluginEntryMirror(e, entry));
            }
            return entries;
        }
    }

    private static final class PluginElementVisitor
    extends SimpleElementVisitor8<PluginEntryMirror, Plugin> {
        private final Elements elements;

        private PluginElementVisitor(Elements elements) {
            this.elements = elements;
        }

        @Override
        public PluginEntryMirror visitType(TypeElement e, Plugin plugin) {
            Objects.requireNonNull(plugin, "Plugin annotation is null.");
            String name = plugin.value();
            if (name.isEmpty()) {
                name = e.getSimpleName().toString();
            }
            PluginEntry.Builder builder = PluginEntry.builder().setKey(name.toLowerCase(Locale.ROOT)).setName(name).setClassName(this.elements.getBinaryName(e).toString());
            Configurable configurable = e.getAnnotation(Configurable.class);
            if (configurable != null) {
                builder.setNamespace("Core").setElementType(configurable.elementType().isEmpty() ? name : configurable.elementType()).setDeferChildren(configurable.deferChildren()).setPrintable(configurable.printObject());
            } else {
                builder.setNamespace(PluginProcessor.getNamespace(e));
            }
            return new PluginEntryMirror(e, builder.get());
        }
    }

    private static final class PluginEntryMirror {
        private final TypeElement element;
        private final PluginEntry entry;

        private PluginEntryMirror(TypeElement element, PluginEntry entry) {
            this.element = element;
            this.entry = entry;
        }
    }
}

