package org.apache.logging.log4j.core.test.plugins;

import org.apache.logging.log4j.plugins.model.PluginEntry;
import org.apache.logging.log4j.plugins.model.PluginService;

public class Log4jPlugins extends PluginService {

  private static final PluginEntry[] ENTRIES = new PluginEntry[] {
    PluginEntry.builder()
      .setKey("alwaysfail")
      .setClassName("org.apache.logging.log4j.core.test.appender.AlwaysFailAppender")
      .setName("AlwaysFail")
      .setNamespace("Core")
      .setElementType("appender")
      .setPrintable(true)
      .get(),
    PluginEntry.builder()
      .setKey("list")
      .setClassName("org.apache.logging.log4j.core.test.appender.ListAppender")
      .setName("List")
      .setNamespace("Core")
      .setElementType("appender")
      .setPrintable(true)
      .get(),
    PluginEntry.builder()
      .setKey("failonce")
      .setClassName("org.apache.logging.log4j.core.test.appender.FailOnceAppender")
      .setName("FailOnce")
      .setNamespace("Core")
      .setElementType("appender")
      .setPrintable(true)
      .get(),
    PluginEntry.builder()
      .setKey("block")
      .setClassName("org.apache.logging.log4j.core.test.appender.BlockingAppender")
      .setName("Block")
      .setNamespace("Core")
      .setElementType("appender")
      .setPrintable(true)
      .get(),
    PluginEntry.builder()
      .setKey("extendedlevel")
      .setClassName("org.apache.logging.log4j.core.test.ExtendedLevels")
      .setName("ExtendedLevel")
      .setNamespace("Level")
      .get()
    };
    @Override
    public PluginEntry[] getEntries() { return ENTRIES; }
}
