package org.apache.logging.log4j.csv.layout.plugins;

import org.apache.logging.log4j.plugins.model.PluginEntry;
import org.apache.logging.log4j.plugins.model.PluginService;

public class Log4jPlugins extends PluginService {

  private static final PluginEntry[] ENTRIES = new PluginEntry[] {
    PluginEntry.builder()
      .setKey("csvlogeventlayout")
      .setClassName("org.apache.logging.log4j.csv.layout.CsvLogEventLayout")
      .setName("CsvLogEventLayout")
      .setNamespace("Core")
      .setElementType("layout")
      .setPrintable(true)
      .get(),
    PluginEntry.builder()
      .setKey("csvparameterlayout")
      .setClassName("org.apache.logging.log4j.csv.layout.CsvParameterLayout")
      .setName("CsvParameterLayout")
      .setNamespace("Core")
      .setElementType("layout")
      .setPrintable(true)
      .get()
    };
    @Override
    public PluginEntry[] getEntries() { return ENTRIES; }
}
