/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.apache.logging.log4j.spi.LoggingSystemProperty;
import org.apache.logging.log4j.util.InternalApi;
import org.apache.logging.log4j.util.LowLevelLogUtil;
import org.apache.logging.log4j.util.PropertiesUtil;

@InternalApi
public final class LoaderUtil {
    private static final ClassLoader[] EMPTY_CLASS_LOADER_ARRAY = new ClassLoader[0];
    private static final SecurityManager SECURITY_MANAGER = System.getSecurityManager();
    private static Boolean ignoreTCCL;
    private static final boolean GET_CLASS_LOADER_DISABLED;
    protected static Boolean forceTcclOnly;
    private static final PrivilegedAction<ClassLoader> TCCL_GETTER;

    private LoaderUtil() {
    }

    public static ClassLoader getClassLoader() {
        return LoaderUtil.getClassLoader(LoaderUtil.class, null);
    }

    public static ClassLoader getClassLoader(Class<?> class1, Class<?> class2) {
        ClassLoader loader2;
        ClassLoader threadContextClassLoader = LoaderUtil.getThreadContextClassLoader();
        ClassLoader loader1 = class1 == null ? null : class1.getClassLoader();
        ClassLoader classLoader = loader2 = class2 == null ? null : class2.getClassLoader();
        if (LoaderUtil.isChild(threadContextClassLoader, loader1)) {
            return LoaderUtil.isChild(threadContextClassLoader, loader2) ? threadContextClassLoader : loader2;
        }
        return LoaderUtil.isChild(loader1, loader2) ? loader1 : loader2;
    }

    public static ClassLoader getThreadContextClassLoader() {
        if (GET_CLASS_LOADER_DISABLED) {
            return LoaderUtil.class.getClassLoader();
        }
        return SECURITY_MANAGER == null ? TCCL_GETTER.run() : AccessController.doPrivileged(TCCL_GETTER);
    }

    private static boolean isChild(ClassLoader loader1, ClassLoader loader2) {
        if (loader1 != null && loader2 != null) {
            ClassLoader parent;
            for (parent = loader1.getParent(); parent != null && parent != loader2; parent = parent.getParent()) {
            }
            return parent != null;
        }
        return loader1 != null;
    }

    public static ClassLoader[] getClassLoaders() {
        LinkedHashSet<ClassLoader> classLoaders;
        block4: {
            ModuleLayer layer;
            block3: {
                classLoaders = new LinkedHashSet<ClassLoader>();
                ClassLoader tcl = LoaderUtil.getThreadContextClassLoader();
                if (tcl != null) {
                    classLoaders.add(tcl);
                }
                if ((layer = LoaderUtil.class.getModule().getLayer()) != null) break block3;
                if (LoaderUtil.isForceTccl()) break block4;
                LoaderUtil.accumulateClassLoaders(LoaderUtil.class.getClassLoader(), classLoaders);
                LoaderUtil.accumulateClassLoaders(tcl == null ? null : tcl.getParent(), classLoaders);
                ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
                if (systemClassLoader == null) break block4;
                classLoaders.add(systemClassLoader);
                break block4;
            }
            LoaderUtil.accumulateLayerClassLoaders(layer, classLoaders);
            if (layer != ModuleLayer.boot()) {
                for (Module module : ModuleLayer.boot().modules()) {
                    LoaderUtil.accumulateClassLoaders(module.getClassLoader(), classLoaders);
                }
            }
        }
        return classLoaders.toArray(EMPTY_CLASS_LOADER_ARRAY);
    }

    private static void accumulateLayerClassLoaders(ModuleLayer layer, Collection<ClassLoader> classLoaders) {
        for (Module module : layer.modules()) {
            LoaderUtil.accumulateClassLoaders(module.getClassLoader(), classLoaders);
        }
        if (layer.parents().size() > 0) {
            for (ModuleLayer parent : layer.parents()) {
                LoaderUtil.accumulateLayerClassLoaders(parent, classLoaders);
            }
        }
    }

    private static void accumulateClassLoaders(ClassLoader loader, Collection<ClassLoader> loaders) {
        if (loader != null && loaders.add(loader)) {
            LoaderUtil.accumulateClassLoaders(loader.getParent(), loaders);
        }
    }

    public static boolean isClassAvailable(String className) {
        try {
            Class<?> clazz = LoaderUtil.loadClass(className);
            return clazz != null;
        }
        catch (ClassNotFoundException | LinkageError e) {
            return false;
        }
        catch (Throwable e) {
            LowLevelLogUtil.logException("Unknown error checking for existence of class: " + className, e);
            return false;
        }
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        if (LoaderUtil.isIgnoreTccl()) {
            return Class.forName(className);
        }
        try {
            ClassLoader tccl = LoaderUtil.getThreadContextClassLoader();
            if (tccl != null) {
                return tccl.loadClass(className);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Class.forName(className);
    }

    public static <T> T newInstanceOf(Class<T> clazz) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException ignored) {
            return clazz.newInstance();
        }
    }

    public static <T> T newInstanceOf(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        return (T)LoaderUtil.newInstanceOf(LoaderUtil.loadClass(className));
    }

    public static <T> T newCheckedInstanceOf(String className, Class<T> clazz) throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return LoaderUtil.newInstanceOf(LoaderUtil.loadClass(className).asSubclass(clazz));
    }

    public static <T> T newCheckedInstanceOfProperty(String propertyName, Class<T> clazz) throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        String className = PropertiesUtil.getProperties().getStringProperty(propertyName);
        if (className == null) {
            return null;
        }
        return LoaderUtil.newCheckedInstanceOf(className, clazz);
    }

    private static boolean isIgnoreTccl() {
        if (ignoreTCCL == null) {
            String ignoreTccl = PropertiesUtil.getProperties().getStringProperty(LoggingSystemProperty.LOADER_IGNORE_THREAD_CONTEXT_LOADER, null);
            ignoreTCCL = ignoreTccl != null && !"false".equalsIgnoreCase(ignoreTccl.trim());
        }
        return ignoreTCCL;
    }

    private static boolean isForceTccl() {
        if (forceTcclOnly == null) {
            try {
                forceTcclOnly = System.getSecurityManager() == null ? Boolean.valueOf(Boolean.getBoolean(LoggingSystemProperty.LOADER_FORCE_THREAD_CONTEXT_LOADER.getSystemKey())) : AccessController.doPrivileged(() -> Boolean.getBoolean(LoggingSystemProperty.LOADER_FORCE_THREAD_CONTEXT_LOADER.getSystemKey()));
            }
            catch (SecurityException se) {
                forceTcclOnly = false;
            }
        }
        return forceTcclOnly;
    }

    public static Collection<URL> findResources(String resource) {
        return LoaderUtil.findResources(resource, true);
    }

    public static Collection<URL> findResources(String resource, boolean useTccl) {
        Collection<UrlResource> urlResources = LoaderUtil.findUrlResources(resource, useTccl);
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>(urlResources.size());
        for (UrlResource urlResource : urlResources) {
            resources.add(urlResource.getUrl());
        }
        return resources;
    }

    public static Collection<UrlResource> findUrlResources(String resource, boolean useTccl) {
        ClassLoader[] candidates = new ClassLoader[]{LoaderUtil.getThreadContextClassLoader(), LoaderUtil.isForceTccl() ? null : LoaderUtil.class.getClassLoader(), LoaderUtil.isForceTccl() || GET_CLASS_LOADER_DISABLED ? null : ClassLoader.getSystemClassLoader()};
        LinkedHashSet<UrlResource> resources = new LinkedHashSet<UrlResource>();
        for (ClassLoader cl : candidates) {
            if (cl == null) continue;
            try {
                Enumeration<URL> resourceEnum = cl.getResources(resource);
                while (resourceEnum.hasMoreElements()) {
                    resources.add(new UrlResource(cl, resourceEnum.nextElement()));
                }
            }
            catch (IOException e) {
                LowLevelLogUtil.logException(e);
            }
        }
        return resources;
    }

    static {
        TCCL_GETTER = new ThreadContextClassLoaderGetter();
        if (SECURITY_MANAGER != null) {
            boolean getClassLoaderDisabled;
            try {
                SECURITY_MANAGER.checkPermission(new RuntimePermission("getClassLoader"));
                getClassLoaderDisabled = false;
            }
            catch (SecurityException ignored) {
                getClassLoaderDisabled = true;
            }
            GET_CLASS_LOADER_DISABLED = getClassLoaderDisabled;
        } else {
            GET_CLASS_LOADER_DISABLED = false;
        }
    }

    public static class UrlResource {
        private final ClassLoader classLoader;
        private final URL url;

        public UrlResource(ClassLoader classLoader, URL url) {
            this.classLoader = classLoader;
            this.url = url;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public URL getUrl() {
            return this.url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UrlResource that = (UrlResource)o;
            if (this.classLoader != null ? !this.classLoader.equals(that.classLoader) : that.classLoader != null) {
                return false;
            }
            return this.url != null ? this.url.equals(that.url) : that.url == null;
        }

        public int hashCode() {
            return Objects.hashCode(this.classLoader) + Objects.hashCode(this.url);
        }
    }

    private static class ThreadContextClassLoaderGetter
    implements PrivilegedAction<ClassLoader> {
        private ThreadContextClassLoaderGetter() {
        }

        @Override
        public ClassLoader run() {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                return cl;
            }
            ClassLoader ccl = LoaderUtil.class.getClassLoader();
            return ccl == null && !GET_CLASS_LOADER_DISABLED ? ClassLoader.getSystemClassLoader() : ccl;
        }
    }
}

