/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.function.BooleanSupplier;

public class LazyBoolean
implements BooleanSupplier {
    private final BooleanSupplier supplier;
    private volatile boolean initialized;
    private volatile boolean value;

    public LazyBoolean(BooleanSupplier supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAsBoolean() {
        boolean uninitialized = !this.initialized;
        boolean value = this.value;
        if (uninitialized) {
            LazyBoolean lazyBoolean = this;
            synchronized (lazyBoolean) {
                boolean bl = uninitialized = !this.initialized;
                if (uninitialized) {
                    this.value = value = this.supplier.getAsBoolean();
                    this.initialized = true;
                }
            }
        }
        return value;
    }

    public synchronized void setAsBoolean(boolean b) {
        this.initialized = false;
        this.value = b;
        this.initialized = true;
    }

    public void reset() {
        this.initialized = false;
    }
}

