/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.slf4j;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogBuilder;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LambdaUtil;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.apache.logging.log4j.util.Supplier;
import org.apache.logging.slf4j.SLF4JLogger;

public class SLF4JLogBuilder
implements LogBuilder {
    private static Message EMPTY_MESSAGE = new SimpleMessage("");
    private static final String FQCN = SLF4JLogBuilder.class.getName();
    private static final Logger LOGGER = StatusLogger.getLogger();
    private ExtendedLogger logger;
    private Level level;
    private Marker marker;
    private Throwable throwable;
    private volatile boolean inUse;
    private final long threadId;

    public SLF4JLogBuilder(SLF4JLogger logger, Level level) {
        this.logger = logger;
        this.level = level;
        this.threadId = Thread.currentThread().getId();
        this.inUse = level != null;
    }

    public SLF4JLogBuilder() {
        this(null, null);
    }

    public LogBuilder reset(SLF4JLogger logger, Level level) {
        this.logger = logger;
        this.level = level;
        this.marker = null;
        this.throwable = null;
        this.inUse = true;
        return this;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    private boolean isValid() {
        if (!this.inUse) {
            LOGGER.warn("Attempt to reuse LogBuilder was ignored. {}", (Object)StackLocatorUtil.getCallerClass((int)2));
            return false;
        }
        if (this.threadId != Thread.currentThread().getId()) {
            LOGGER.warn("LogBuilder can only be used on the owning thread. {}", (Object)StackLocatorUtil.getCallerClass((int)2));
            return false;
        }
        return true;
    }

    private void logMessage(Message message) {
        try {
            this.logger.logMessage(FQCN, this.level, this.marker, message, this.throwable);
        }
        finally {
            this.inUse = false;
        }
    }

    public LogBuilder withMarker(Marker marker) {
        this.marker = marker;
        return this;
    }

    public LogBuilder withThrowable(Throwable throwable) {
        this.throwable = throwable;
        return this;
    }

    public LogBuilder withLocation() {
        LOGGER.info("Call to withLocation() ignored since SLF4J does not support setting location information.");
        return this;
    }

    public LogBuilder withLocation(StackTraceElement location) {
        return this.withLocation();
    }

    public void log(CharSequence message) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message));
        }
    }

    public void log(String message) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message));
        }
    }

    public void log(String message, Object ... params) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message, params));
        }
    }

    public void log(String message, Supplier<?> ... params) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message, LambdaUtil.getAll(params)));
        }
    }

    public void log(Message message) {
        if (this.isValid()) {
            this.logMessage(message);
        }
    }

    public void log(Supplier<Message> messageSupplier) {
        if (this.isValid()) {
            this.logMessage((Message)messageSupplier.get());
        }
    }

    public Message logAndGet(Supplier<Message> messageSupplier) {
        Message message = null;
        if (this.isValid()) {
            message = (Message)messageSupplier.get();
            this.logMessage(message);
        }
        return message;
    }

    public void log(Object message) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message));
        }
    }

    public void log(String message, Object p0) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message, p0));
        }
    }

    public void log(String message, Object p0, Object p1) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message, p0, p1));
        }
    }

    public void log(String message, Object p0, Object p1, Object p2) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message, p0, p1, p2));
        }
    }

    public void log(String message, Object p0, Object p1, Object p2, Object p3) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message, p0, p1, p2, p3));
        }
    }

    public void log(String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message, p0, p1, p2, p3, p4));
        }
    }

    public void log(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message, p0, p1, p2, p3, p4, p5));
        }
    }

    public void log(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message, p0, p1, p2, p3, p4, p5, p6));
        }
    }

    public void log(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message, p0, p1, p2, p3, p4, p5, p6, p7));
        }
    }

    public void log(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message, p0, p1, p2, p3, p4, p5, p6, p7, p8));
        }
    }

    public void log(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9));
        }
    }

    public void log() {
        if (this.isValid()) {
            this.logMessage(EMPTY_MESSAGE);
        }
    }
}

