/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.test.junit;

import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.Hashtable;
import java.util.stream.Stream;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.opentest4j.TestAbortedException;

public class URLStreamHandlerFactories {
    private static final Field FACTORY_FIELD = Stream.of(URL.class.getDeclaredFields()).filter(field -> URLStreamHandlerFactory.class.equals(field.getType())).findFirst().orElseThrow(() -> new TestAbortedException("java.net.URL does not declare a java.net.URLStreamHandlerFactory field"));
    private static final Field HANDLERS_FIELD = FieldUtils.getDeclaredField(URL.class, (String)"handlers", (boolean)true);

    public static URLStreamHandlerFactory getURLStreamHandlerFactory() {
        try {
            return (URLStreamHandlerFactory)FieldUtils.readStaticField((Field)FACTORY_FIELD, (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    public static void setURLStreamHandlerFactory(URLStreamHandlerFactory factory) {
        try {
            Object handlers = HANDLERS_FIELD.get(null);
            if (handlers instanceof Hashtable) {
                ((Hashtable)handlers).clear();
            }
            FieldUtils.writeStaticField((Field)FACTORY_FIELD, null, (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        if (factory != null) {
            URL.setURLStreamHandlerFactory(factory);
        }
    }
}

