/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.test.junit;

import org.apache.logging.log4j.test.TestProperties;
import org.apache.logging.log4j.test.junit.ExtensionContextAnchor;
import org.apache.logging.log4j.util.PropertySource;
import org.junit.jupiter.api.extension.ExtensionContext;

public class TestPropertySource
implements PropertySource {
    private static final String PREFIX = "log4j2.";
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContextAnchor.LOG4J2_NAMESPACE.append(new Object[]{"properties"});
    private static final TestProperties EMPTY_PROPERTIES = new EmptyTestProperties();

    public int getPriority() {
        return Integer.MIN_VALUE;
    }

    public static TestProperties createProperties(ExtensionContext context) {
        TestProperties props = TestPropertySource.getProperties(context);
        if (props instanceof JUnitTestProperties && context.equals(((JUnitTestProperties)props).getContext())) {
            return props;
        }
        props = new JUnitTestProperties(context);
        ExtensionContextAnchor.setAttribute(TestProperties.class, props, context);
        return props;
    }

    public static TestProperties getProperties() {
        return TestPropertySource.getProperties(null);
    }

    private static TestProperties getProperties(ExtensionContext context) {
        TestProperties props;
        ExtensionContext actualContext;
        ExtensionContext extensionContext = actualContext = context != null ? context : ExtensionContextAnchor.getContext();
        if (actualContext != null && (props = ExtensionContextAnchor.getAttribute(TestProperties.class, TestProperties.class, actualContext)) != null) {
            return props;
        }
        return EMPTY_PROPERTIES;
    }

    public CharSequence getNormalForm(Iterable<? extends CharSequence> tokens) {
        CharSequence camelCase = PropertySource.Util.joinAsCamelCase(tokens);
        return camelCase.length() > 0 ? PREFIX + camelCase.toString() : null;
    }

    public String getProperty(String key) {
        return TestPropertySource.getProperties().getProperty(key);
    }

    public boolean containsProperty(String key) {
        return TestPropertySource.getProperties().containsProperty(key);
    }

    private static class EmptyTestProperties
    implements TestProperties {
        private EmptyTestProperties() {
        }

        @Override
        public String getProperty(String key) {
            return null;
        }

        @Override
        public boolean containsProperty(String key) {
            return false;
        }

        @Override
        public void setProperty(String key, String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearProperty(String key) {
            throw new UnsupportedOperationException();
        }
    }

    private static class JUnitTestProperties
    implements TestProperties {
        private final ExtensionContext context;
        private final ExtensionContext.Store store;

        public JUnitTestProperties(ExtensionContext context) {
            this.context = context;
            this.store = context.getStore(NAMESPACE);
        }

        public ExtensionContext getContext() {
            return this.context;
        }

        @Override
        public String getProperty(String key) {
            return (String)this.store.get((Object)key, String.class);
        }

        @Override
        public boolean containsProperty(String key) {
            return this.getProperty(key) != null;
        }

        @Override
        public void setProperty(String key, String value) {
            this.store.put((Object)key, (Object)value);
        }

        @Override
        public void clearProperty(String key) {
            this.store.remove((Object)key, String.class);
        }
    }
}

