/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.visit;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.plugins.Inject;
import org.apache.logging.log4j.plugins.Node;
import org.apache.logging.log4j.plugins.util.TypeUtil;
import org.apache.logging.log4j.plugins.visit.NodeVisitor;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.StringBuilders;

public class PluginLoggerContextVisitor
implements NodeVisitor {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final LoggerContext loggerContext;

    @Inject
    public PluginLoggerContextVisitor(WeakReference<LoggerContext> loggerContext) {
        this.loggerContext = (LoggerContext)loggerContext.get();
    }

    public Object visitField(Field field, Node node, StringBuilder debugLog) {
        if (TypeUtil.isAssignable((Type)field.getGenericType(), LoggerContext.class)) {
            StringBuilders.appendKeyDqValueWithJoiner((StringBuilder)debugLog, (String)"loggerContext", (Object)this.loggerContext, (CharSequence)", ");
            return Cast.cast((Object)this.loggerContext);
        }
        LOGGER.error("Field {} annotated with @PluginLoggerContext is not compatible with type {}", (Object)field, this.loggerContext.getClass());
        return null;
    }

    public Object visitParameter(Parameter parameter, Node node, StringBuilder debugLog) {
        if (TypeUtil.isAssignable((Type)parameter.getParameterizedType(), this.loggerContext.getClass())) {
            StringBuilders.appendKeyDqValueWithJoiner((StringBuilder)debugLog, (String)"loggerContext", (Object)this.loggerContext, (CharSequence)", ");
            return Cast.cast((Object)this.loggerContext);
        }
        LOGGER.error("Parameter {} annotated with @PluginLoggerContext is not compatible with type {}", (Object)parameter, this.loggerContext.getClass());
        return null;
    }
}

