/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.model;

import org.apache.logging.log4j.plugins.model.PluginEntry;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.Lazy;

public class PluginType<T> {
    private final PluginEntry pluginEntry;
    private final Lazy<Class<T>> pluginClass;

    public PluginType(PluginEntry pluginEntry, Class<T> pluginClass) {
        this.pluginEntry = pluginEntry;
        this.pluginClass = Lazy.value(pluginClass);
    }

    public PluginType(PluginEntry pluginEntry, ClassLoader classLoader) {
        this.pluginEntry = pluginEntry;
        this.pluginClass = Lazy.lazy(() -> {
            try {
                return (Class)Cast.cast(classLoader.loadClass(pluginEntry.getClassName()));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("No class named " + pluginEntry.getClassName() + " located for element " + pluginEntry.getName(), e);
            }
        });
    }

    public PluginEntry getPluginEntry() {
        return this.pluginEntry;
    }

    public Class<T> getPluginClass() {
        return (Class)this.pluginClass.value();
    }

    public String getElementType() {
        return this.pluginEntry.getElementType();
    }

    public String getKey() {
        return this.pluginEntry.getKey();
    }

    public boolean isObjectPrintable() {
        return this.pluginEntry.isPrintable();
    }

    public boolean isDeferChildren() {
        return this.pluginEntry.isDeferChildren();
    }

    public String getNamespace() {
        return this.pluginEntry.getNamespace();
    }

    public String getName() {
        return this.pluginEntry.getName();
    }

    public String toString() {
        return "PluginType [pluginClass=" + this.pluginClass.toString() + ", key=" + this.pluginEntry.getKey() + ", elementType=" + this.pluginEntry.getElementType() + ", isObjectPrintable=" + this.pluginEntry.isPrintable() + ", isDeferChildren==" + this.pluginEntry.isDeferChildren() + ", namespace=" + this.pluginEntry.getNamespace() + "]";
    }
}

