/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di;

import java.util.function.Supplier;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.util.Lazy;

public final class Binding<T>
implements Supplier<T> {
    private final Key<T> key;
    private final Supplier<? extends T> factory;

    private Binding(Key<T> key, Supplier<? extends T> factory) {
        this.key = key;
        this.factory = factory;
    }

    public Key<T> getKey() {
        return this.key;
    }

    @Override
    public T get() {
        return this.factory.get();
    }

    public static <T> DSL<T> from(Key<T> key) {
        return new DSL<T>(key);
    }

    public static <T> DSL<T> from(Class<T> type) {
        return new DSL<T>(Key.forClass(type));
    }

    public static final class DSL<T> {
        private final Key<T> key;

        private DSL(Key<T> key) {
            this.key = key;
        }

        public Binding<T> to(Supplier<? extends T> factory) {
            return new Binding<T>(this.key, factory);
        }

        public Binding<T> toSingleton(Supplier<? extends T> factory) {
            return new Binding<T>(this.key, Lazy.lazy(factory));
        }

        public Binding<T> toInstance(T instance) {
            return new Binding<T>(this.key, Lazy.value(instance));
        }
    }
}

