/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jpa.converter;

import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.time.MutableInstant;
import org.apache.logging.log4j.util.Strings;

@Converter(autoApply=false)
public class InstantAttributeConverter
implements AttributeConverter<Instant, String> {
    public String convertToDatabaseColumn(Instant instant) {
        if (instant == null) {
            return null;
        }
        return instant.getEpochSecond() + "," + instant.getNanoOfSecond();
    }

    public Instant convertToEntityAttribute(String s) {
        if (Strings.isEmpty((CharSequence)s)) {
            return null;
        }
        int pos = s.indexOf(",");
        long epochSecond = Long.parseLong(s.substring(0, pos));
        int nanos = Integer.parseInt(s.substring(pos + 1, s.length()));
        MutableInstant result = new MutableInstant();
        result.initFromEpochSecond(epochSecond, nanos);
        return result;
    }
}

