/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.flume.appender;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.flume.event.SimpleEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.util.Patterns;
import org.apache.logging.log4j.core.util.UuidUtil;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StructuredDataId;
import org.apache.logging.log4j.message.StructuredDataMessage;

public class FlumeEvent
extends SimpleEvent
implements LogEvent {
    static final String GUID = "guId";
    private static final long serialVersionUID = -8988674608627854140L;
    private static final String DEFAULT_MDC_PREFIX = "";
    private static final String DEFAULT_EVENT_PREFIX = "";
    private static final String EVENT_TYPE = "eventType";
    private static final String EVENT_ID = "eventId";
    private static final String TIMESTAMP = "timeStamp";
    private final LogEvent event;
    private final Map<String, String> contextMap = new HashMap<String, String>();
    private final boolean compress;

    public FlumeEvent(LogEvent event, String includes, String excludes, String required, String mdcPrefix, String eventPrefix, boolean compress) {
        String[] array;
        this.event = event;
        this.compress = compress;
        Map headers = this.getHeaders();
        headers.put(TIMESTAMP, Long.toString(event.getTimeMillis()));
        if (mdcPrefix == null) {
            mdcPrefix = "";
        }
        if (eventPrefix == null) {
            eventPrefix = "";
        }
        Map mdc = event.getContextMap();
        if (includes != null) {
            array = includes.split(Patterns.COMMA_SEPARATOR);
            if (array.length > 0) {
                for (String str : array) {
                    if (!mdc.containsKey(str = str.trim())) continue;
                    this.contextMap.put(str, (String)mdc.get(str));
                }
            }
        } else if (excludes != null) {
            array = excludes.split(Patterns.COMMA_SEPARATOR);
            if (array.length > 0) {
                ArrayList<String> list = new ArrayList<String>(array.length);
                for (String value : array) {
                    list.add(value.trim());
                }
                for (Map.Entry entry : mdc.entrySet()) {
                    if (list.contains(entry.getKey())) continue;
                    this.contextMap.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
        } else {
            this.contextMap.putAll(mdc);
        }
        if (required != null && (array = required.split(Patterns.COMMA_SEPARATOR)).length > 0) {
            for (String str : array) {
                if (mdc.containsKey(str = str.trim())) continue;
                throw new LoggingException("Required key " + str + " is missing from the MDC");
            }
        }
        String guid = UuidUtil.getTimeBasedUuid().toString();
        Message message = event.getMessage();
        if (message instanceof MapMessage) {
            ((MapMessage)message).put(GUID, guid);
            if (message instanceof StructuredDataMessage) {
                this.addStructuredData(eventPrefix, headers, (StructuredDataMessage)message);
            }
            this.addMapData(eventPrefix, headers, (MapMessage)message);
        } else {
            headers.put(GUID, guid);
        }
        this.addContextData(mdcPrefix, headers, this.contextMap);
    }

    protected void addStructuredData(String prefix, Map<String, String> fields, StructuredDataMessage msg) {
        fields.put(prefix + EVENT_TYPE, msg.getType());
        StructuredDataId id = msg.getId();
        fields.put(prefix + EVENT_ID, id.getName());
    }

    protected void addMapData(String prefix, Map<String, String> fields, MapMessage msg) {
        Map data = msg.getData();
        for (Map.Entry entry : data.entrySet()) {
            fields.put(prefix + (String)entry.getKey(), (String)entry.getValue());
        }
    }

    protected void addContextData(String prefix, Map<String, String> fields, Map<String, String> context) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : context.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            fields.put(prefix + entry.getKey(), entry.getValue());
            map.put(prefix + entry.getKey(), entry.getValue());
        }
        context.clear();
        context.putAll(map);
    }

    public void setBody(byte[] body) {
        if (body == null || body.length == 0) {
            super.setBody(new byte[0]);
            return;
        }
        if (this.compress) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                GZIPOutputStream os = new GZIPOutputStream(baos);
                os.write(body);
                os.close();
            }
            catch (IOException ioe) {
                throw new LoggingException("Unable to compress message", (Throwable)ioe);
            }
            super.setBody(baos.toByteArray());
        } else {
            super.setBody(body);
        }
    }

    public String getLoggerFqcn() {
        return this.event.getLoggerFqcn();
    }

    public Level getLevel() {
        return this.event.getLevel();
    }

    public String getLoggerName() {
        return this.event.getLoggerName();
    }

    public StackTraceElement getSource() {
        return this.event.getSource();
    }

    public Message getMessage() {
        return this.event.getMessage();
    }

    public Marker getMarker() {
        return this.event.getMarker();
    }

    public String getThreadName() {
        return this.event.getThreadName();
    }

    public long getTimeMillis() {
        return this.event.getTimeMillis();
    }

    public Throwable getThrown() {
        return this.event.getThrown();
    }

    public ThrowableProxy getThrownProxy() {
        return this.event.getThrownProxy();
    }

    public Map<String, String> getContextMap() {
        return this.contextMap;
    }

    public ThreadContext.ContextStack getContextStack() {
        return this.event.getContextStack();
    }

    public boolean isIncludeLocation() {
        return this.event.isIncludeLocation();
    }

    public void setIncludeLocation(boolean includeLocation) {
        this.event.setIncludeLocation(includeLocation);
    }

    public boolean isEndOfBatch() {
        return this.event.isEndOfBatch();
    }

    public void setEndOfBatch(boolean endOfBatch) {
        this.event.setEndOfBatch(endOfBatch);
    }
}

