/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.nosql.appender.couchdb;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.nosql.appender.DefaultNoSqlObject;
import org.apache.logging.log4j.nosql.appender.NoSqlConnection;
import org.apache.logging.log4j.nosql.appender.NoSqlObject;
import org.lightcouch.CouchDbClient;
import org.lightcouch.Response;

public final class CouchDbConnection
implements NoSqlConnection<Map<String, Object>, DefaultNoSqlObject> {
    private final CouchDbClient client;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public CouchDbConnection(CouchDbClient client) {
        this.client = client;
    }

    @Override
    public DefaultNoSqlObject createObject() {
        return new DefaultNoSqlObject();
    }

    public DefaultNoSqlObject[] createList(int length) {
        return new DefaultNoSqlObject[length];
    }

    @Override
    public void insertObject(NoSqlObject<Map<String, Object>> object) {
        try {
            Response response = this.client.save(object.unwrap());
            if (response.getError() != null && response.getError().length() > 0) {
                throw new AppenderLoggingException("Failed to write log event to CouchDB due to error: " + response.getError() + '.');
            }
        }
        catch (Exception e) {
            throw new AppenderLoggingException("Failed to write log event to CouchDB due to error: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.client.shutdown();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }
}

