/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.ErrorHandler;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.util.StackLocatorUtil;

public class ListErrorHandler
implements ErrorHandler {
    private final ArrayList<StatusData> statusData = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStatusData(String msg, Throwable t) {
        ArrayList<StatusData> arrayList = this.statusData;
        synchronized (arrayList) {
            StackTraceElement caller = StackLocatorUtil.getStackTraceElement((int)3);
            String threadName = Thread.currentThread().getName();
            this.statusData.add(new StatusData(caller, Level.ERROR, (Message)new SimpleMessage(msg), t, threadName));
        }
    }

    public void error(String msg) {
        this.addStatusData(msg, null);
    }

    public void error(String msg, Throwable t) {
        this.addStatusData(msg, t);
    }

    public void error(String msg, LogEvent event, Throwable t) {
        this.addStatusData(msg, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<StatusData> arrayList = this.statusData;
        synchronized (arrayList) {
            this.statusData.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<StatusData> getStatusData() {
        ArrayList<StatusData> arrayList = this.statusData;
        synchronized (arrayList) {
            return ((List)this.statusData.clone()).stream();
        }
    }

    public Stream<StatusData> findStatusData(String regex) {
        return this.getStatusData().filter(data -> data.getMessage().getFormattedMessage().matches(regex));
    }
}

