<!-- vim: set syn=markdown : -->
<!--
    Licensed to the Apache Software Foundation (ASF) under one or more
    contributor license agreements.  See the NOTICE file distributed with
    this work for additional information regarding copyright ownership.
    The ASF licenses this file to You under the Apache License, Version 2.0
    (the "License"); you may not use this file except in compliance with
    the License.  You may obtain a copy of the License at

         http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
-->

# Articles and Tutorials

A collection of external articles and tutorials about Log4j 2. The [Log4j 2 manual](manual/index.html) is the ultimate
guide for up-to-date and detailed information on how to configure and use Log4j 2.

## Chinese

* [Log4j 2.6免垃圾收集](https://www.infoq.cn/news/2016/06/log4j-garbage-free/)
(June 12, 2016)
* [详解log4j2(上) - 从基础到实战](https://blog.csdn.net/autfish/article/details/51203709)
(April 20, 2016)
* [Log4j2使用笔记](https://www.jianshu.com/p/7aec512a003c)
(November 3, 2015)
* [过渡到全新Log4j：Log4j项目管理委员会访谈](https://www.infoq.cn/news/2015/09/interview-log4j-pmc/)
(September 14, 2015)
* [Log4j版本1生命周期终结](https://www.infoq.cn/news/2015/09/log4j-version-1-reaches-eol/)
(September 3, 2015)
* [Apache Log4j 2.0值得升级吗](https://www.infoq.cn/news/2014/08/apache-log4j2/)
(August 5, 2014)
* [log4j2 使用详解](https://blog.csdn.net/lrenjun/article/details/8178875)
(November 13, 2012)
* [Log4j2配置文件详解](https://web.archive.org/web/20211016221310/https://my.oschina.net/xianggao/blog/523401)
(October 29, 2015)

## English

* [Log4J2 | Create custom log levels and how to use them](https://medium.com/codex/log4j2-create-custom-log-levels-and-how-to-use-them-48685e133fd1)
(April 29, 2021)  
* [Log4j2 Tutorial 7 – Working Mechanism Of Default Rollover Strategy](http://makeseleniumeasy.com/2021/04/26/log4j2-tutorial-7-working-mechanism-of-default-rollover-strategy/)
(April 26, 2021)
* [Log4j2 Tutorial 6 – Introduction To RollingFileAppender And Its Triggers And Strategies](http://makeseleniumeasy.com/2021/04/20/log4j2-tutorial-6-introduction-to-rollingfileappender-and-its-triggers-and-strategies/)
(April 20, 2021)
* [Log4j2 Tutorial 5 – XML Configuration File To Log Into File And Console Using Log4j2 Together](http://makeseleniumeasy.com/2021/04/13/log4j2-tutorial-5-xml-configuration-file-to-log-into-file-and-console-using-log4j2-together/)
(April, 13, 2021)  
* [Log4j2 Tutorial 4 – Print Logs In External File Using XML Configuration File Of Log4J2](http://makeseleniumeasy.com/2021/04/09/log4j2-tutorial-4-print-logs-in-external-file-using-xml-configuration-file-of-log4j2/)
  (April 9, 2021)
* [Log4j2 Tutorial 3 – Setup Console Appender Using XML Configuration File](http://makeseleniumeasy.com/2021/03/24/log4j2-tutorial-3-setup-console-appender-using-xml-configuration-file/)
  (March 24, 2021)
* [Log4j2 Tutorial 2 – Creating Log4j2 Maven Project With Default Configuration File](http://makeseleniumeasy.com/2021/03/17/log4j2-tutorial-2-creating-log4j2-maven-project-with-default-configuration-file/)
  (March 17, 2021)
* [Log4j2 Tutorial 1 – Introduction To Apache Log4j2](http://makeseleniumeasy.com/2021/03/11/log4j2-tutorial-1-introduction-to-apache-log4j2/)
  (March 11, 2021)  
* [How to make a custom message converter for Log4J2](https://petrepopescu.tech/2021/03/how-to-make-a-custom-message-converter-for-log4j2/)
(March 4, 2021)  
* [How to configure Log4j2 in your WildFly applications](http://www.mastertheboss.com/jbossas/jboss-log/how-to-use-log4j2-in-your-wildfly-applications/)
(August 16, 2020)
* [Configuring Log4j2 in a Spring Boot 2 application](http://www.masterspringboot.com/configuration/logging/configuring-log4j2-in-spring-boot-applications)
(August 16, 2020)
* [Getting the most out of the Log4j 2 API](https://www.ralphgoers.com/post/getting-the-most-out-of-the-log4j-2-api)
(January 1, 2020)
* [Programmatic Configuration with Log4j 2](https://www.baeldung.com/log4j2-programmatic-config)
(December 31, 2019)
* [Log4j 1 Compatibility in Log4j 2](https://www.ralphgoers.com/post/log4j-1-compatibility-in-log4j-2)
(December 22, 2019)
* [Why was Log4j 2 created](https://www.ralphgoers.com/post/why-was-log4j-2-created)
(December 14, 2019)
* [A Guide to Logging in Java](https://www.marcobehler.com/guides/java-logging)
(June 23, 2019)
* [Exploring the Secrets of Java Logs: Log4j 2 Log System](https://www.alibabacloud.com/blog/exploring-the-secrets-of-java-logs-log4j-2-log-system_594821)
(May 17, 2019)
* [Apache Log4j 2 Tutorials](https://mkyong.com/logging/apache-log4j-2-tutorials/)
(March 27, 2019)
* [Java Logging Frameworks: log4j vs logback vs log4j2](https://stackify.com/compare-java-logging-frameworks/)
(October 30, 2018)
* [Log4j2 Tutorial](https://howtodoinjava.com/log4j2/)
(June 3, 2018)
* [In Java How to Create your own Logging Level using Log4j (Configuring Log4j 2)](https://crunchify.com/java-how-to-create-your-own-logging-level-in-log4j-configuring-log4j/)
{May 30, 2018)
* [Programmatic Configuration with Log4j 2](https://www.baeldung.com/log4j2-programmatic-config)
(May 22, 2018)
* [Tales from the Field: Migrating from Log4J to Log4J2](https://www.javacodegeeks.com/2018/03/tales-from-the-field-migrating-from-log4j-to-log4j2.html)
(March 12, 2018)
* [Log4j 2 Best Practices example](https://examples.javacodegeeks.com/enterprise-java/log4j/log4j-2-best-practices-example/)
(November 14, 2017)
* [Logging Fundamentals](https://web.archive.org/web/20180308003803/http://musigma.org/logging/2017/11/06/logging.html)
(November 6, 2017)
* [Allocation free logging with Log4j2](http://www.rationaljava.com/2017/10/allocation-free-logging-with-log4j2.html)
(October 27, 2017)
* [Benchmarking Java logging frameworks](https://www.loggly.com/blog/benchmarking-java-logging-frameworks/)
(October 25, 2017)
* [Log4j 2 and Lambda Expressions](https://www.baeldung.com/log4j-2-lazy-logging)
(August 22, 2017)
* [How to use Log4j 2 with Spring Boot](https://www.callicoder.com/spring-boot-log4j-2-example/)
(August 11, 2017)
* [Log4j 2 - RollingFileAppender example](https://www.boraji.com/log4j-2-rollingfileappender-example)
(July 26, 2017)
* [How Log4J2 Works: 10 Ways to Get the Most Out Of It](https://stackify.com/log4j2-java/)
(June 14, 2017)
* [Intro to Log4j2 – Appenders, Layouts and Filters](https://www.baeldung.com/log4j2-appenders-layouts-filters)
(February 28, 2017)
* [Getting Your Own Log4j2 File for Mule via Spring](https://dzone.com/articles/getting-own-log4j2-file-for-mule-via-spring)
(December 29, 2016)
* [Loading a Log4j Configuration for a specific EJB](https://garygregory.wordpress.com/2016/11/27/loading-a-log4j-configuration-for-a-specific-ejb/)
(November 27, 2016)
* [Log4j2 Logging: A Primer](https://anishekagarwal.medium.com/log4j2-logging-a-primer-f10ed18e9de6)
(October 15, 2016)
* [Log4j2 Example Tutorial – Configuration, Levels, Appenders](https://www.digitalocean.com/community/tutorials/log4j2-example-tutorial-configuration-levels-appenders)
(July 6, 2016)
* [Log4j2 HTMLLayout Configuration Example](https://howtodoinjava.com/log4j2/log4j2-htmllayout-configuration-example/)
(June 27, 2016)
* [Log4j2 java.util.logging (JUL) Adapter Example](https://javaevangelist.blogspot.com/2016/06/log4j2-javautillogging-jul-adapter.html)
(June 24, 2016)
* [Log4J 2 Configuration: Using the Properties File](https://dzone.com/articles/log4j-2-configuration-using-properties-file)
(May 18, 2016)
* [Using Log4j 2 with Sprint Boot](https://springframework.guru/using-log4j-2-spring-boot/)
(April 7, 2016)
* [Log4j 2.6 Goes Garbage-Free](https://www.infoq.com/news/2016/05/log4j-garbage-free/)
(May 30, 2016)
* [What's New in Log4j 2.6](https://web.archive.org/web/20180306104946/http://musigma.org/java/log4j/2016/05/29/log4j-2.6.html)
(May 29, 2016)
* [Asynchronous Logging With Log4j 2](https://springframework.guru/asynchronous-logging-with-log4j-2/)
(March 31, 2016)
* [Log4J 2 Configuration: Using YAML](https://springframework.guru/log4j-2-configuration-using-yaml/)
(March 26, 2016)
* [Log4J 2 Configuration: Using JSON](https://springframework.guru/log4j-2-configuration-using-json/)
(March 23, 2016)
* [Getting Logstash 2.x Ready for Log4j2](https://web.archive.org/web/20220315041422/https://qbox.io/blog/getting-logstash-2x-ready-for-log4j2)
(March 10, 2016)
* [Log4J 2 Configuration: Using XML](https://springframework.guru/log4j-2-configuration-using-xml/)
(March 10, 2016)
* [Log4J 2 Configuration: Using Properties File](https://springframework.guru/log4j-2-configuration-using-properties-file/)
(March 8, 2016)
* [Introducing Log4j 2 – Enterprise Class Logging](https://springframework.guru/introducing-log4j-enterprise-class-logging/)
(February 8, 2016)
* [Better Performing Non-Logging Logger Calls in Log4j2](https://www.javacodegeeks.com/2015/10/better-performing-non-logging-logger-calls-in-log4j2.html)
(October 20, 2015)
* [Better Performing Non-Logging Logger Calls in Log4j2](https://marxsoftware.blogspot.com/2015/10/log4j2-non-logging-performance.html)
(October 15, 2015)
* [Easy and Consistent Log4j2 Logger Naming](https://www.javacodegeeks.com/2015/10/easy-and-consistent-log4j2-logger-naming.html)
(October 10, 2015)
* [Writing clean logging code using Java 8 lambdas](https://garygregory.wordpress.com/2015/09/16/a-gentle-introduction-to-the-log4j-api-and-lambda-basics/)
(September 16, 2015)
* [The Art of Test Driven Development: Understanding Logging](https://garygregory.wordpress.com/2015/09/10/the-art-of-test-driven-development-understanding-logging/)
(September 10, 2015)
* [The Art of Test Driven Development: Per-Test Logging](https://garygregory.wordpress.com/2015/09/08/the-art-of-test-driven-development-per-test-logging/)
(September 8, 2015)
* [The Transition to a New Log4j: a Q&amp;A with Log4j's Project Management Committee](https://www.infoq.com/news/2015/09/interview-log4j-pmc/)
(September 8, 2015)
* [Log4j Version 1 Reaches End of Life](https://www.infoq.com/news/2015/08/log4j-version-1-reaches-eol/)
(August 26, 2015)
* [Apache Logging Services Project Announces Log4j 1 End-Of-Life; Recommends Upgrade to Log4j 2](https://news.apache.org/foundation/entry/apache_logging_services_project_announces)
(August 6, 2015)
* [Per request debugging with Log4j 2 filters](https://www.innoq.com/en/blog/per-request-debugging-with-log4j2/)
(May 8, 2015)
* [Log4j 2 configuration depending on environment](https://blog.oio.de/2015/04/27/log4j-2-configuration-depending-environment/)
(April 27, 2015)
* [Apache Log4j 2 Tutorial – Configuration, Levels, Appenders, Lookup, Layouts and Filters Example](http://www.journaldev.com/7128/apache-log4j-2-tutorial-configuration-levels-appenders-lookup-layouts-and-filters-example)
(March 16, 2015)
* [Disrupting your Asynchronous Loggers](https://blogs.mulesoft.com/dev-guides/how-to-tutorials/mule-3-6-asynchronous-logging/)
(March 5, 2015)
* [Extending Log4j2 - Creating Custom Log4j2 Plugins](https://andrew-flower.com/blog/Create_Custom_Log4j_Plugins)
(February 20, 2015)
* [Log4j2 - a crash course...](https://andrew-flower.com/blog/Basic_Log4j2_Configuration)
(February 10, 2015)
* [Log4j2 with log4j2.xml Configuration Example](https://memorynotfound.com/log4j2-with-log4j2-xml-configuration-example/)
(February 10, 2015)
* [Logging From Your Java Application Using Log4j2](https://www.rapid7.com/blog/post/2015/02/05/logging-from-your-java-application-using-log4j2/)
(February 5, 2015)
* [Asynchronous Logging in Mule 3.6](https://blogs.mulesoft.com/dev-guides/how-to-tutorials/mule-3-6-asynchronous-logging/)
(January 20, 2015)
* [Apache Log4j 2.0 - Worth the Upgrade?](https://www.infoq.com/news/2014/07/apache-log4j2/)
(July 31, 2014)
* [log4j2 xml configuration example](https://mycuteblog.com/log4j2-xml-configuration-example/)
(July 26, 2014)
* [Log4j 2 in Production – Making it Fly](https://tech.finn.no/2014/07/01/log4j2-in-production-making-it-fly/)
(July 2, 2014)
* [Log4j 2: Performance Close to Insane](https://grobmeier.solutions/log4j-2-performance-close-to-insane-20072013.html)
(July 20, 2013)
* [Hacker News: Asynchronous Loggers for Low-Latency Logging](https://news.ycombinator.com/item?id=5612035)
(April 26, 2013)
* [The New Log4j 2.0](https://grobmeier.solutions/the-new-log4j-2-0-05122012.html)
(December 5, 2012)

## English (Videos)

* [Log4J2 and Java configuration with properties file](https://www.youtube.com/watch?v=sdOiA1Xql0o)
  (February 18, 2018)
* [Apache Log4j 2 Configuration| Log4j2 with JDK 9.0](https://www.youtube.com/watch?v=BbcSNOtEGWs)
  (January 8, 2018)
* [Spring Boot - log4j 2 configuration example](https://www.youtube.com/watch?v=KKO5wGi_vEc)
  (December 30,2017)
* [Understanding and working with Log4j2 for logging in Selenium framework (Part B)](https://www.youtube.com/watch?v=-XNvCNHjIKw)
  (December 20, 2016)
* [Understanding and working with Log4j2 for logging in Selenium framework (Part A)](https://www.youtube.com/watch?v=RWZ0gsfkkc4)
  (December 18, 2016)
* [Matt Sicker - Asynchronous Logging in Log4j 2.6 (CJUG Lightning Talk)](https://vimeo.com/169542136)
  (June 2, 2016)
  * Errata: "ThresholdFilter" should be "BurstFilter"
* [Nancy M Schorr - Log4j2 with Java and Maven for Logging](https://www.youtube.com/watch?v=Yv0n-4AsOiI)
  (October 14, 2015)
* [Ramesh Rajaram - Log4j Key Features](https://www.youtube.com/watch?v=EWftNoRhS_M)
  (April 10, 2015)
* [Matt Sicker - Introducing Log4j 2.0](https://www.youtube.com/watch?v=ZzVSs_JEhgs)
  (May 6, 2014)
* [Nicholas Williams - Log4j 2 in Web Applications: A Deeper Look at Effective Java EE Logging](https://www.youtube.com/watch?v=HB0r5DuxGPI)
  (May 6, 2014)

## German

* [Apache Log4j 2.6 läuft nun auch ohne Müll](https://entwickler.de/java/apache-log4j-26-lauft-nun-auch-ohne-mull/)
(May 31, 2016)
* [Logging konsolidieren und Performance gewinnen](https://www.innoq.com/en/articles/2015/01/logging-konsolidieren-log4j2/)
(January 23, 2015)

## Japanese

* [中年プログラマーの息抜き](https://tm-b.hatenablog.com/entry/2016/08/18/200715)
(August 18, 2016)
* [【log4j2】ThreadContextを利用してすべてのログに追加情報を出力する](https://minor.hatenablog.com/entry/2016/05/22/193556)
(May 22, 2016)
* [Log4j 2でログ出力をテストするサンプルソース](https://qiita.com/kazurof/items/abbd42f11bfc125f3190)
(February 22, 2016)
* [新Log4jへの移行: Log4jプロジェクト管理グループとのQ&amp;A](https://www.infoq.com/jp/news/2015/09/interview-log4j-pmc/)
(September 27, 2015)
* [Log4jバージョン1のサポートが終了](https://www.infoq.com/jp/news/2015/09/log4j-version-1-reaches-eol/)
(September 23, 2015)
* [log4j2の設定ファイル(XML)](https://qiita.com/pica/items/f801c74848f748f76b58)
(July 27, 2015)
* [Log4j2の使い方めも](https://yamashiro0110.hatenadiary.jp/entry/2014/08/24/093336)
(August 24, 2014)
* [Apache Log4j 2.0 - アップグレードする価値はあるか？](https://www.infoq.com/jp/news/2014/08/apache-log4j2/)
(August 17, 2014)
* [Log4j2を試してみる](https://kazuhira-r.hatenablog.com/entry/20140628/1403959552)
(June 28, 2014)
* [log4j2にログを集める](https://nabedge.blogspot.com/2013/10/log4j2.html)
(October 26, 2013)

## Korean

* [Log4j 2 설정하기](https://dveamer.github.io/java/Log4j2.html)
(January 24, 2016)
* [Log4j 2 환경설정 [설정 파일 사용 시]](https://www.egovframe.go.kr/wiki/doku.php?id=egovframework:rte3:fdl:%EC%84%A4%EC%A0%95_%ED%8C%8C%EC%9D%BC%EC%9D%84_%EC%82%AC%EC%9A%A9%ED%95%98%EB%8A%94_%EB%B0%A9%EB%B2%95)
(May 14, 2014)
