/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.logging.log4j.core.impl;

import java.util.List;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.message.Message;

/**
 *
 */
public interface LogEventFactory extends LocationAwareLogEventFactory {

    LogEvent createEvent(String loggerName, Marker marker, String fqcn, Level level, Message data,
                         List<Property> properties, Throwable t);

    @Override
    default LogEvent createEvent(
            String loggerName,
            Marker marker,
            String fqcn,
            @SuppressWarnings("unused") StackTraceElement location,
            Level level,
            Message data,
            List<Property> properties,
            Throwable t) {
        return createEvent(loggerName, marker, fqcn, level, data, properties, t);
    }
}
