/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.test.junit;

import java.io.IOException;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ParameterizedNoReferenceMessageFactory;
import org.apache.logging.log4j.simple.SimpleLogger;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.test.ListStatusListener;
import org.apache.logging.log4j.test.junit.ExtensionContextAnchor;
import org.apache.logging.log4j.test.junit.TypeBasedParameterResolver;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ExtensionContextException;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.support.ReflectionSupport;

class StatusLoggerExtension
extends TypeBasedParameterResolver<ListStatusListener>
implements BeforeAllCallback,
BeforeEachCallback,
TestExecutionExceptionHandler {
    private static final Object KEY = ListStatusListener.class;

    public StatusLoggerExtension() {
        super((Type)((Object)ListStatusListener.class));
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        ListStatusListenerHolder holder = new ListStatusListenerHolder(context, null);
        ExtensionContextAnchor.setAttribute(KEY, holder, context);
        ReflectionSupport.findFields((Class)context.getRequiredTestClass(), f -> ModifierSupport.isStatic((Member)f) && f.getType().equals(ListStatusListener.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN).forEach(f -> {
            try {
                f.setAccessible(true);
                f.set(null, holder.getStatusListener());
            }
            catch (ReflectiveOperationException e) {
                throw new ExtensionContextException("Failed to inject field.", (Throwable)e);
            }
        });
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        ListStatusListenerHolder parentHolder = ExtensionContextAnchor.getAttribute(KEY, ListStatusListenerHolder.class, context);
        ListStatusListener parent = parentHolder != null ? parentHolder.getStatusListener() : null;
        ListStatusListenerHolder holder = new ListStatusListenerHolder(context, parent);
        ExtensionContextAnchor.setAttribute(KEY, holder, context);
        ReflectionSupport.findFields((Class)context.getRequiredTestClass(), f -> ModifierSupport.isNotStatic((Member)f) && f.getType().equals(ListStatusListener.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN).forEach(f -> {
            try {
                f.setAccessible(true);
                f.set(context.getRequiredTestInstance(), holder.getStatusListener());
            }
            catch (ReflectiveOperationException e) {
                throw new ExtensionContextException("Failed to inject field.", (Throwable)e);
            }
        });
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        ListStatusListenerHolder holder = ExtensionContextAnchor.getAttribute(KEY, ListStatusListenerHolder.class, context);
        if (holder != null) {
            holder.handleException(context, throwable);
        }
        throw throwable;
    }

    @Override
    public ListStatusListener resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        ListStatusListenerHolder holder = ExtensionContextAnchor.getAttribute(KEY, ListStatusListenerHolder.class, extensionContext);
        return holder.getStatusListener();
    }

    private static class JUnitListStatusListener
    implements ListStatusListener {
        private final ExtensionContext context;
        private final ListStatusListener parent;
        private final ArrayList<StatusData> statusData = new ArrayList();

        public JUnitListStatusListener(ExtensionContext context, ListStatusListener parent) {
            this.context = context;
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void log(StatusData data) {
            if (this.context.equals(ExtensionContextAnchor.getContext())) {
                ArrayList<StatusData> arrayList = this.statusData;
                synchronized (arrayList) {
                    this.statusData.add(data);
                }
            }
        }

        public Level getStatusLevel() {
            return Level.DEBUG;
        }

        public void close() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Stream<StatusData> getStatusData() {
            ArrayList<StatusData> arrayList = this.statusData;
            synchronized (arrayList) {
                List clone = (List)this.statusData.clone();
                return this.parent != null ? Stream.concat(this.parent.getStatusData(), clone.stream()) : clone.stream();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            ArrayList<StatusData> arrayList = this.statusData;
            synchronized (arrayList) {
                this.statusData.clear();
            }
        }
    }

    private static class ListStatusListenerHolder
    implements ExtensionContext.Store.CloseableResource {
        private final StatusLogger statusLogger = StatusLogger.getLogger();
        private final ListStatusListener statusListener;

        public ListStatusListenerHolder(ExtensionContext context, ListStatusListener parent) {
            this.statusListener = new JUnitListStatusListener(context, parent);
            this.statusLogger.registerListener((StatusListener)this.statusListener);
        }

        public ListStatusListener getStatusListener() {
            return this.statusListener;
        }

        public void close() throws Throwable {
            this.statusLogger.removeListener((StatusListener)this.statusListener);
        }

        public void handleException(ExtensionContext context, Throwable throwable) {
            SimpleLogger logger = new SimpleLogger("StatusLoggerExtension", Level.ALL, false, false, false, false, null, (MessageFactory)ParameterizedNoReferenceMessageFactory.INSTANCE, PropertiesUtil.getProperties(), System.err);
            logger.error("Test {} failed.\nDumping status data:", (Object)context.getDisplayName());
            this.statusListener.getStatusData().forEach(arg_0 -> ListStatusListenerHolder.lambda$handleException$0((Logger)logger, arg_0));
        }

        private static /* synthetic */ void lambda$handleException$0(Logger logger, StatusData data) {
            logger.atLevel(data.getLevel()).withThrowable(data.getThrowable()).withLocation(data.getStackTraceElement()).log("{} {}", (Object)DateTimeFormatter.ISO_LOCAL_TIME.format(Instant.ofEpochMilli(data.getTimestamp())), (Object)data.getMessage());
        }
    }
}

