/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.mongodb3;

import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.CreateCollectionOptions;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.nosql.AbstractNoSqlConnection;
import org.apache.logging.log4j.core.appender.nosql.NoSqlObject;
import org.apache.logging.log4j.mongodb3.MongoDbDocumentObject;
import org.apache.logging.log4j.status.StatusLogger;
import org.bson.Document;

public final class MongoDbConnection
extends AbstractNoSqlConnection<Document, MongoDbDocumentObject> {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final MongoCollection<Document> collection;
    private final MongoClient mongoClient;

    private static MongoCollection<Document> getOrCreateMongoCollection(MongoDatabase database, String collectionName, boolean isCapped, Integer sizeInBytes) {
        try {
            LOGGER.debug("Gettting collection '{}'...", (Object)collectionName);
            return database.getCollection(collectionName);
        }
        catch (IllegalStateException e) {
            LOGGER.debug("Collection '{}' does not exist.", (Object)collectionName);
            CreateCollectionOptions options = new CreateCollectionOptions().capped(isCapped).sizeInBytes((long)sizeInBytes.intValue());
            LOGGER.debug("Creating collection {} (capped = {}, sizeInBytes = {})", (Object)collectionName, (Object)isCapped, (Object)sizeInBytes);
            database.createCollection(collectionName, options);
            return database.getCollection(collectionName);
        }
    }

    public MongoDbConnection(MongoClient mongoClient, MongoDatabase mongoDatabase, String collectionName, boolean isCapped, Integer sizeInBytes) {
        this.mongoClient = mongoClient;
        this.collection = MongoDbConnection.getOrCreateMongoCollection(mongoDatabase, collectionName, isCapped, sizeInBytes);
    }

    public void closeImpl() {
        this.mongoClient.close();
    }

    public MongoDbDocumentObject[] createList(int length) {
        return new MongoDbDocumentObject[length];
    }

    public MongoDbDocumentObject createObject() {
        return new MongoDbDocumentObject();
    }

    public void insertObject(NoSqlObject<Document> object) {
        try {
            Document unwrapped = (Document)object.unwrap();
            LOGGER.debug("Inserting object {}", (Object)unwrapped);
            this.collection.insertOne((Object)unwrapped);
        }
        catch (MongoException e) {
            throw new AppenderLoggingException("Failed to write log event to MongoDB due to error: " + e.getMessage(), (Throwable)e);
        }
    }
}

