/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.lookup.StructuredDataLookup;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class StructuredDataLookupTest {
    private StructuredDataLookup dataLookup;

    @BeforeEach
    public void setUp() {
        this.dataLookup = new StructuredDataLookup();
    }

    @Test
    public void testCorrectEvent() {
        StructuredDataMessage msg = new StructuredDataMessage("TestId", "This is a test", "Audit");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.DEBUG).setMessage((Message)msg).build();
        Assertions.assertEquals((Object)"Audit", (Object)this.dataLookup.lookup((LogEvent)event, "type"));
        Assertions.assertEquals((Object)"Audit", (Object)this.dataLookup.lookup((LogEvent)event, "type".toUpperCase()));
        Assertions.assertEquals((Object)"TestId", (Object)this.dataLookup.lookup((LogEvent)event, "id"));
        Assertions.assertEquals((Object)"TestId", (Object)this.dataLookup.lookup((LogEvent)event, "id".toUpperCase()));
        Assertions.assertNull((Object)this.dataLookup.lookup((LogEvent)event, "BadKey"));
        Assertions.assertNull((Object)this.dataLookup.lookup((LogEvent)event, null));
    }

    @Test
    public void testNullLookup() {
        Assertions.assertNull((Object)this.dataLookup.lookup(null, null));
        Assertions.assertNull((Object)this.dataLookup.lookup(null));
    }

    @Test
    void testWrongEvent() {
        LogEvent mockEvent = (LogEvent)Mockito.mock(LogEvent.class);
        Mockito.when((Object)mockEvent.getMessage()).thenReturn(Mockito.mock(Message.class));
        Assertions.assertNull((Object)this.dataLookup.lookup(mockEvent, "ignored"));
    }
}

