/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.BasicConfigurationFactory;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.layout.SerializedLayout;
import org.apache.logging.log4j.junit.ThreadContextRule;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.apache.logging.log4j.util.FilteredObjectInputStream;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class SerializedLayoutTest {
    private static final String DAT_PATH = "target/test-classes/serializedEvent.dat";
    LoggerContext ctx = LoggerContext.getContext();
    Logger root = this.ctx.getRootLogger();
    static ConfigurationFactory cf = new BasicConfigurationFactory();
    static boolean useObjectInputStream = false;
    @Rule
    public final ThreadContextRule threadContextRule = new ThreadContextRule();
    private static final String body = "<log4j:message><![CDATA[empty mdc]]></log4j:message>\r";
    private static final String[] expected = new String[]{"Logger=root Level=DEBUG Message=starting mdc pattern test", "Logger=root Level=DEBUG Message=empty mdc", "Logger=root Level=DEBUG Message=filled mdc", "Logger=root Level=ERROR Message=finished mdc pattern test", "Logger=root Level=ERROR Message=Throwing an exception"};

    @BeforeClass
    public static void setupClass() {
        try {
            Class.forName("java.io.ObjectInputFilter");
            useObjectInputStream = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)cf);
        LoggerContext ctx = LoggerContext.getContext();
        ctx.reconfigure();
    }

    @AfterClass
    public static void cleanupClass() {
        ConfigurationFactory.removeConfigurationFactory((ConfigurationFactory)cf);
    }

    @Test
    public void testLayout() throws Exception {
        Object appender2;
        Map appenders = this.root.getAppenders();
        for (Object appender2 : appenders.values()) {
            this.root.removeAppender((Appender)appender2);
        }
        SerializedLayout layout = SerializedLayout.createLayout();
        appender2 = new ListAppender("List", null, (Layout<? extends Serializable>)layout, false, true);
        appender2.start();
        this.root.addAppender((Appender)appender2);
        this.root.setLevel(Level.DEBUG);
        this.root.debug("starting mdc pattern test");
        this.root.debug("empty mdc");
        ThreadContext.put((String)"key1", (String)"value1");
        ThreadContext.put((String)"key2", (String)"value2");
        this.root.debug("filled mdc");
        ThreadContext.remove((String)"key1");
        ThreadContext.remove((String)"key2");
        this.root.error("finished mdc pattern test", (Throwable)new NullPointerException("test"));
        IllegalStateException parent = new IllegalStateException("Test");
        LoggingException child = new LoggingException("This is a test", (Throwable)parent);
        this.root.error("Throwing an exception", (Throwable)child);
        appender2.stop();
        List<byte[]> data = ((ListAppender)((Object)appender2)).getData();
        Assert.assertTrue((data.size() > 0 ? 1 : 0) != 0);
        int i = 0;
        for (byte[] item : data) {
            LogEvent event;
            ByteArrayInputStream bais = new ByteArrayInputStream(item);
            ObjectInputStream ois = useObjectInputStream ? new ObjectInputStream(bais) : new FilteredObjectInputStream((InputStream)bais);
            try {
                event = (LogEvent)ois.readObject();
            }
            catch (IOException ioe) {
                System.err.println("Exception processing item " + i);
                throw ioe;
            }
            Assert.assertTrue((String)"Incorrect event", (boolean)event.toString().equals(expected[i]));
            ++i;
        }
        for (Appender app : appenders.values()) {
            this.root.addAppender(app);
        }
    }

    @Test
    public void testSerialization() throws Exception {
        SerializedLayout layout = SerializedLayout.createLayout();
        LoggingException throwable = new LoggingException("Test");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world!")).setThrown((Throwable)throwable).build();
        byte[] result = layout.toByteArray((LogEvent)event);
        Assert.assertNotNull((Object)result);
        FileOutputStream fos = new FileOutputStream(DAT_PATH);
        fos.write(layout.getHeader());
        fos.write(result);
        fos.close();
    }

    @Test
    public void testDeserialization() throws Exception {
        this.testSerialization();
        File file = new File(DAT_PATH);
        FileInputStream fis = new FileInputStream(file);
        try (ObjectInputStream ois = useObjectInputStream ? new ObjectInputStream(fis) : new FilteredObjectInputStream((InputStream)fis);){
            LogEvent event = (LogEvent)ois.readObject();
            Assert.assertNotNull((Object)event);
        }
    }
}

