/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.junit.UsingAnyThreadContext;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StringMapMessage;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="GelfLayout3Test.xml")
@UsingAnyThreadContext
@Tag(value="json")
public class GelfLayout3Test {
    @Test
    public void gelfLayout(LoggerContext context, @Named ListAppender list) throws IOException {
        list.clear();
        ExtendedLogger logger = context.getLogger(this.getClass());
        ThreadContext.put((String)"loginId", (String)"rgoers");
        ThreadContext.put((String)"internalId", (String)"12345");
        logger.info("My Test Message");
        String gelf = list.getMessages().get(0);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode json = mapper.readTree(gelf);
        Assertions.assertEquals((Object)"My Test Message", (Object)json.get("short_message").asText());
        Assertions.assertEquals((Object)"myhost", (Object)json.get("host").asText());
        Assertions.assertNotNull((Object)json.get("_mdc.loginId"));
        Assertions.assertEquals((Object)"rgoers", (Object)json.get("_mdc.loginId").asText());
        Assertions.assertNull((Object)json.get("_mdc.internalId"));
        Assertions.assertNull((Object)json.get("_mdc.requestId"));
        String message = json.get("full_message").asText();
        Assertions.assertTrue((boolean)message.contains("loginId=rgoers"));
        Assertions.assertTrue((boolean)message.contains("GelfLayout3Test"));
        Assertions.assertNull((Object)json.get("_map.arg1"));
        Assertions.assertNull((Object)json.get("_map.arg2"));
        Assertions.assertNull((Object)json.get("_empty"));
        Assertions.assertEquals((Object)"FOO", (Object)json.get("_foo").asText());
    }

    @Test
    public void mapMessage(LoggerContext context, @Named ListAppender list) throws IOException {
        list.clear();
        ExtendedLogger logger = context.getLogger(this.getClass());
        ThreadContext.put((String)"loginId", (String)"rgoers");
        ThreadContext.put((String)"internalId", (String)"12345");
        StringMapMessage message = new StringMapMessage();
        message.put("arg1", "test1");
        message.put("arg2", "");
        message.put("arg3", "test3");
        message.put("message", "My Test Message");
        logger.info((Message)message);
        String gelf = list.getMessages().get(0);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode json = mapper.readTree(gelf);
        Assertions.assertEquals((Object)"arg1=\"test1\" arg2=\"\" arg3=\"test3\" message=\"My Test Message\"", (Object)json.get("short_message").asText());
        Assertions.assertEquals((Object)"myhost", (Object)json.get("host").asText());
        Assertions.assertNotNull((Object)json.get("_mdc.loginId"));
        Assertions.assertEquals((Object)"rgoers", (Object)json.get("_mdc.loginId").asText());
        Assertions.assertNull((Object)json.get("_mdc.internalId"));
        Assertions.assertNull((Object)json.get("_mdc.requestId"));
        String msg = json.get("full_message").asText();
        Assertions.assertTrue((boolean)msg.contains("loginId=rgoers"));
        Assertions.assertTrue((boolean)msg.contains("GelfLayout3Test"));
        Assertions.assertTrue((boolean)msg.contains("arg1=\"test1\""));
        Assertions.assertNull((Object)json.get("_map.arg2"));
        Assertions.assertEquals((Object)"test1", (Object)json.get("_map.arg1").asText());
        Assertions.assertEquals((Object)"test3", (Object)json.get("_map.arg3").asText());
        Assertions.assertNull((Object)json.get("_empty"));
        Assertions.assertEquals((Object)"FOO", (Object)json.get("_foo").asText());
    }
}

