/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.impl.ThrowableFormatOptions;
import org.apache.logging.log4j.core.pattern.JAnsiTextRenderer;
import org.apache.logging.log4j.core.pattern.TextRenderer;
import org.apache.logging.log4j.util.Strings;
import org.fusesource.jansi.AnsiRenderer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class ThrowableFormatOptionsTest {
    private static ThrowableFormatOptions test(String[] options, int expectedLines, String expectedSeparator, List<String> expectedPackages) {
        ThrowableFormatOptions tfo = ThrowableFormatOptions.newInstance((String[])options);
        Assertions.assertEquals((int)expectedLines, (int)tfo.getLines(), (String)"getLines");
        Assertions.assertEquals((Object)expectedSeparator, (Object)tfo.getSeparator(), (String)"getSeparator");
        Assertions.assertEquals(expectedPackages, (Object)tfo.getIgnorePackages(), (String)"getPackages");
        Assertions.assertEquals((Object)(expectedLines == Integer.MAX_VALUE ? 1 : 0), (Object)tfo.allLines(), (String)"allLines");
        Assertions.assertEquals((Object)(expectedLines != 0 ? 1 : 0), (Object)tfo.anyLines(), (String)"anyLines");
        Assertions.assertEquals((int)0, (int)tfo.minLines(0), (String)"minLines");
        Assertions.assertEquals((int)expectedLines, (int)tfo.minLines(Integer.MAX_VALUE), (String)"minLines");
        Assertions.assertEquals((Object)(expectedPackages != null && !expectedPackages.isEmpty() ? 1 : 0), (Object)tfo.hasPackages(), (String)"hasPackages");
        Assertions.assertNotNull((Object)tfo.toString(), (String)"toString");
        return tfo;
    }

    @Test
    public void testNull() {
        ThrowableFormatOptionsTest.test(null, Integer.MAX_VALUE, Strings.LINE_SEPARATOR, null);
    }

    @Test
    public void testEmpty() {
        ThrowableFormatOptionsTest.test(new String[0], Integer.MAX_VALUE, Strings.LINE_SEPARATOR, null);
    }

    @Test
    public void testOneNullElement() {
        ThrowableFormatOptionsTest.test(new String[]{null}, Integer.MAX_VALUE, Strings.LINE_SEPARATOR, null);
    }

    @Test
    public void testOneEmptyElement() {
        ThrowableFormatOptionsTest.test(new String[]{""}, Integer.MAX_VALUE, Strings.LINE_SEPARATOR, null);
    }

    @Test
    public void testFull() {
        ThrowableFormatOptionsTest.test(new String[]{"full"}, Integer.MAX_VALUE, Strings.LINE_SEPARATOR, null);
    }

    @Test
    public void testFullAnsi() {
        ThrowableFormatOptions tfo = ThrowableFormatOptionsTest.test(new String[]{"full", "ansi"}, Integer.MAX_VALUE, Strings.LINE_SEPARATOR, null);
        this.testFullAnsiEmptyConfig(tfo);
    }

    @Test
    public void testFullAnsiEmptyConfig() {
        ThrowableFormatOptions tfo = ThrowableFormatOptionsTest.test(new String[]{"full", "ansi()"}, Integer.MAX_VALUE, Strings.LINE_SEPARATOR, null);
        this.testFullAnsiEmptyConfig(tfo);
    }

    private void testFullAnsiEmptyConfig(ThrowableFormatOptions tfo) {
        TextRenderer textRenderer = tfo.getTextRenderer();
        Assertions.assertNotNull((Object)textRenderer);
        Assertions.assertTrue((boolean)(textRenderer instanceof JAnsiTextRenderer));
        JAnsiTextRenderer jansiRenderer = (JAnsiTextRenderer)textRenderer;
        Map styleMap = jansiRenderer.getStyleMap();
        Assertions.assertFalse((boolean)styleMap.isEmpty());
        Assertions.assertNotNull(styleMap.get("Name"));
    }

    @Test
    public void testFullAnsiWithCustomStyle() {
        ThrowableFormatOptions tfo = ThrowableFormatOptionsTest.test(new String[]{"full", "ansi(Warning=red)"}, Integer.MAX_VALUE, Strings.LINE_SEPARATOR, null);
        TextRenderer textRenderer = tfo.getTextRenderer();
        Assertions.assertNotNull((Object)textRenderer);
        Assertions.assertTrue((boolean)(textRenderer instanceof JAnsiTextRenderer));
        JAnsiTextRenderer jansiRenderer = (JAnsiTextRenderer)textRenderer;
        Map styleMap = jansiRenderer.getStyleMap();
        Assertions.assertArrayEquals((Object[])new AnsiRenderer.Code[]{AnsiRenderer.Code.RED}, (Object[])((Object[])styleMap.get("Warning")));
    }

    @Test
    public void testFullAnsiWithCustomStyles() {
        ThrowableFormatOptions tfo = ThrowableFormatOptionsTest.test(new String[]{"full", "ansi(Warning=red Key=blue Value=cyan)"}, Integer.MAX_VALUE, Strings.LINE_SEPARATOR, null);
        TextRenderer textRenderer = tfo.getTextRenderer();
        Assertions.assertNotNull((Object)textRenderer);
        Assertions.assertTrue((boolean)(textRenderer instanceof JAnsiTextRenderer));
        JAnsiTextRenderer jansiRenderer = (JAnsiTextRenderer)textRenderer;
        Map styleMap = jansiRenderer.getStyleMap();
        Assertions.assertArrayEquals((Object[])new AnsiRenderer.Code[]{AnsiRenderer.Code.RED}, (Object[])((Object[])styleMap.get("Warning")));
        Assertions.assertArrayEquals((Object[])new AnsiRenderer.Code[]{AnsiRenderer.Code.BLUE}, (Object[])((Object[])styleMap.get("Key")));
        Assertions.assertArrayEquals((Object[])new AnsiRenderer.Code[]{AnsiRenderer.Code.CYAN}, (Object[])((Object[])styleMap.get("Value")));
    }

    @Test
    public void testFullAnsiWithCustomComplexStyles() {
        ThrowableFormatOptions tfo = ThrowableFormatOptionsTest.test(new String[]{"full", "ansi(Warning=red Key=blue,bg_red Value=cyan,bg_black,underline)"}, Integer.MAX_VALUE, Strings.LINE_SEPARATOR, null);
        TextRenderer textRenderer = tfo.getTextRenderer();
        Assertions.assertNotNull((Object)textRenderer);
        Assertions.assertTrue((boolean)(textRenderer instanceof JAnsiTextRenderer));
        JAnsiTextRenderer jansiRenderer = (JAnsiTextRenderer)textRenderer;
        Map styleMap = jansiRenderer.getStyleMap();
        Assertions.assertArrayEquals((Object[])new AnsiRenderer.Code[]{AnsiRenderer.Code.RED}, (Object[])((Object[])styleMap.get("Warning")));
        Assertions.assertArrayEquals((Object[])new AnsiRenderer.Code[]{AnsiRenderer.Code.BLUE, AnsiRenderer.Code.BG_RED}, (Object[])((Object[])styleMap.get("Key")));
        Assertions.assertArrayEquals((Object[])new AnsiRenderer.Code[]{AnsiRenderer.Code.CYAN, AnsiRenderer.Code.BG_BLACK, AnsiRenderer.Code.UNDERLINE}, (Object[])((Object[])styleMap.get("Value")));
    }

    @Test
    public void testNone() {
        ThrowableFormatOptionsTest.test(new String[]{"none"}, 0, Strings.LINE_SEPARATOR, null);
    }

    @Test
    public void testShort() {
        ThrowableFormatOptionsTest.test(new String[]{"short"}, 2, Strings.LINE_SEPARATOR, null);
    }

    @Test
    public void testDepth() {
        ThrowableFormatOptionsTest.test(new String[]{"10"}, 10, Strings.LINE_SEPARATOR, null);
    }

    @Test
    public void testSeparator() {
        ThrowableFormatOptionsTest.test(new String[]{"separator(|)"}, Integer.MAX_VALUE, "|", null);
    }

    @Test
    public void testSeparatorAsEmpty() {
        ThrowableFormatOptionsTest.test(new String[]{"separator()"}, Integer.MAX_VALUE, "", null);
    }

    @Test
    public void testSeparatorAsDefaultLineSeparator() {
        ThrowableFormatOptionsTest.test(new String[]{"separator(" + Strings.LINE_SEPARATOR + ')'}, Integer.MAX_VALUE, Strings.LINE_SEPARATOR, null);
    }

    @Test
    public void testSeparatorAsMultipleCharacters() {
        ThrowableFormatOptionsTest.test(new String[]{"separator( | )"}, Integer.MAX_VALUE, " | ", null);
    }

    @Test
    public void testFullAndSeparator() {
        ThrowableFormatOptionsTest.test(new String[]{"full", "separator(|)"}, Integer.MAX_VALUE, "|", null);
    }

    @Test
    public void testFullAndFiltersAndSeparator() {
        ThrowableFormatOptionsTest.test(new String[]{"full", "filters(org.junit)", "separator(|)"}, Integer.MAX_VALUE, "|", Collections.singletonList("org.junit"));
    }

    @Test
    public void testNoneAndSeparator() {
        ThrowableFormatOptionsTest.test(new String[]{"none", "separator(|)"}, 0, "|", null);
    }

    @Test
    public void testShortAndSeparator() {
        ThrowableFormatOptionsTest.test(new String[]{"short", "separator(|)"}, 2, "|", null);
    }

    @Test
    public void testDepthAndSeparator() {
        ThrowableFormatOptionsTest.test(new String[]{"10", "separator(|)"}, 10, "|", null);
    }

    @Test
    public void testFilters() {
        ThrowableFormatOptionsTest.test(new String[]{"filters(packages)"}, Integer.MAX_VALUE, Strings.LINE_SEPARATOR, Collections.singletonList("packages"));
    }

    @Test
    public void testFiltersAsEmpty() {
        ThrowableFormatOptionsTest.test(new String[]{"filters()"}, Integer.MAX_VALUE, Strings.LINE_SEPARATOR, null);
    }

    @Test
    public void testFiltersAsMultiplePackages() {
        ThrowableFormatOptionsTest.test(new String[]{"filters(package1,package2)"}, Integer.MAX_VALUE, Strings.LINE_SEPARATOR, Arrays.asList("package1", "package2"));
    }

    @Test
    public void testFullAndFilters() {
        ThrowableFormatOptionsTest.test(new String[]{"full", "filters(packages)"}, Integer.MAX_VALUE, Strings.LINE_SEPARATOR, Collections.singletonList("packages"));
    }

    @Test
    public void testNoneAndFilters() {
        ThrowableFormatOptionsTest.test(new String[]{"none", "filters(packages)"}, 0, Strings.LINE_SEPARATOR, Collections.singletonList("packages"));
    }

    @Test
    public void testShortAndFilters() {
        ThrowableFormatOptionsTest.test(new String[]{"short", "filters(packages)"}, 2, Strings.LINE_SEPARATOR, Collections.singletonList("packages"));
    }

    @Test
    public void testDepthAndFilters() {
        ThrowableFormatOptionsTest.test(new String[]{"10", "filters(packages)"}, 10, Strings.LINE_SEPARATOR, Collections.singletonList("packages"));
    }

    @Test
    public void testFullAndSeparatorAndFilter() {
        ThrowableFormatOptionsTest.test(new String[]{"full", "separator(|)", "filters(packages)"}, Integer.MAX_VALUE, "|", Collections.singletonList("packages"));
    }

    @Test
    public void testFullAndSeparatorAndFilters() {
        ThrowableFormatOptionsTest.test(new String[]{"full", "separator(|)", "filters(package1,package2)"}, Integer.MAX_VALUE, "|", Arrays.asList("package1", "package2"));
    }

    @Test
    public void testNoneAndSeparatorAndFilters() {
        ThrowableFormatOptionsTest.test(new String[]{"none", "separator(|)", "filters(packages)"}, 0, "|", Collections.singletonList("packages"));
    }

    @Test
    public void testShortAndSeparatorAndFilters() {
        ThrowableFormatOptionsTest.test(new String[]{"short", "separator(|)", "filters(packages)"}, 2, "|", Collections.singletonList("packages"));
    }

    @Test
    public void testDepthAndSeparatorAndFilters() {
        ThrowableFormatOptionsTest.test(new String[]{"10", "separator(|)", "filters(packages)"}, 10, "|", Collections.singletonList("packages"));
    }

    @Test
    public void testSingleOptionFullAndFilters() {
        ThrowableFormatOptionsTest.test(new String[]{"full,filters(packages)"}, Integer.MAX_VALUE, Strings.LINE_SEPARATOR, Collections.singletonList("packages"));
    }

    @Test
    public void testSingleOptionNoneAndFilters() {
        ThrowableFormatOptionsTest.test(new String[]{"none,filters(packages)"}, 0, Strings.LINE_SEPARATOR, Collections.singletonList("packages"));
    }

    @Test
    public void testSingleOptionShortAndFilters() {
        ThrowableFormatOptionsTest.test(new String[]{"short,filters(packages)"}, 2, Strings.LINE_SEPARATOR, Collections.singletonList("packages"));
    }

    @Test
    public void testSingleOptionDepthAndFilters() {
        ThrowableFormatOptionsTest.test(new String[]{"10,filters(packages)"}, 10, Strings.LINE_SEPARATOR, Collections.singletonList("packages"));
    }

    @Test
    public void testSingleOptionFullAndMultipleFilters() {
        ThrowableFormatOptionsTest.test(new String[]{"full,filters(package1,package2)"}, Integer.MAX_VALUE, Strings.LINE_SEPARATOR, Arrays.asList("package1", "package2"));
    }

    @Test
    public void testSingleOptionNoneAndMultipleFilters() {
        ThrowableFormatOptionsTest.test(new String[]{"none,filters(package1,package2)"}, 0, Strings.LINE_SEPARATOR, Arrays.asList("package1", "package2"));
    }

    @Test
    public void testSingleOptionShortAndMultipleFilters() {
        ThrowableFormatOptionsTest.test(new String[]{"short,filters(package1,package2)"}, 2, Strings.LINE_SEPARATOR, Arrays.asList("package1", "package2"));
    }

    @Test
    public void testSingleOptionDepthAndMultipleFilters() {
        ThrowableFormatOptionsTest.test(new String[]{"10,filters(package1,package2)"}, 10, Strings.LINE_SEPARATOR, Arrays.asList("package1", "package2"));
    }
}

