/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.filter.RegexFilter;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.status.StatusLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class RegexFilterTest {
    @BeforeAll
    public static void before() {
        StatusLogger.getLogger().setLevel(Level.OFF);
    }

    @Test
    public void testThresholds() throws Exception {
        RegexFilter filter = RegexFilter.createFilter((String)".* test .*", null, (Boolean)false, null, null);
        filter.start();
        Assertions.assertTrue((boolean)filter.isStarted());
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.DEBUG, null, (Object)"This is a test message", (Throwable)null));
        Assertions.assertSame((Object)Filter.Result.DENY, (Object)filter.filter(null, Level.ERROR, null, (Object)"This is not a test", (Throwable)null));
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("Another test message")).build();
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event));
        event = Log4jLogEvent.newBuilder().setLevel(Level.ERROR).setMessage((Message)new SimpleMessage("test")).build();
        Assertions.assertSame((Object)Filter.Result.DENY, (Object)filter.filter((LogEvent)event));
        filter = RegexFilter.createFilter(null, null, (Boolean)false, null, null);
        Assertions.assertNull((Object)filter);
    }

    @Test
    public void testDotAllPattern() throws Exception {
        String singleLine = "test single line matches";
        String multiLine = "test multi line matches\nsome more lines";
        RegexFilter filter = RegexFilter.createFilter((String)".*line.*", (String[])new String[]{"DOTALL", "COMMENTS"}, (Boolean)false, (Filter.Result)Filter.Result.DENY, (Filter.Result)Filter.Result.ACCEPT);
        Filter.Result singleLineResult = filter.filter(null, null, null, (Object)"test single line matches", (Throwable)null);
        Filter.Result multiLineResult = filter.filter(null, null, null, (Object)"test multi line matches\nsome more lines", (Throwable)null);
        MatcherAssert.assertThat((Object)singleLineResult, (Matcher)CoreMatchers.equalTo((Object)Filter.Result.DENY));
        MatcherAssert.assertThat((Object)multiLineResult, (Matcher)CoreMatchers.equalTo((Object)Filter.Result.DENY));
    }

    @Test
    public void testNoMsg() throws Exception {
        RegexFilter filter = RegexFilter.createFilter((String)".* test .*", null, (Boolean)false, null, null);
        filter.start();
        Assertions.assertTrue((boolean)filter.isStarted());
        Assertions.assertSame((Object)Filter.Result.DENY, (Object)filter.filter(null, Level.DEBUG, null, null, (Throwable)null));
        Assertions.assertSame((Object)Filter.Result.DENY, (Object)filter.filter(null, Level.DEBUG, null, (Message)null, (Throwable)null));
        Assertions.assertSame((Object)Filter.Result.DENY, (Object)filter.filter(null, Level.DEBUG, null, null, (Object[])null));
    }

    @Test
    public void testParameterizedMsg() throws Exception {
        String msg = "params {} {}";
        Object[] params = new Object[]{"foo", "bar"};
        RegexFilter rawFilter = RegexFilter.createFilter((String)"params \\{\\} \\{\\}", null, (Boolean)true, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.DENY);
        Filter.Result rawResult = rawFilter.filter(null, null, null, "params {} {}", params);
        MatcherAssert.assertThat((Object)rawResult, (Matcher)CoreMatchers.equalTo((Object)Filter.Result.ACCEPT));
        RegexFilter fmtFilter = RegexFilter.createFilter((String)"params foo bar", null, (Boolean)false, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.DENY);
        Filter.Result fmtResult = fmtFilter.filter(null, null, null, "params {} {}", params);
        MatcherAssert.assertThat((Object)fmtResult, (Matcher)CoreMatchers.equalTo((Object)Filter.Result.ACCEPT));
    }
}

