/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.processor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.config.plugins.processor.PluginCache;
import org.apache.logging.log4j.core.config.plugins.processor.PluginEntry;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PluginCacheTest {
    @Test
    public void testOutputIsReproducibleWhenInputOrderingChanges() throws IOException {
        PluginCache cacheA = new PluginCache();
        this.createCategory(cacheA, "one", Arrays.asList("bravo", "alpha", "charlie"));
        this.createCategory(cacheA, "two", Arrays.asList("alpha", "charlie", "bravo"));
        Assert.assertEquals((long)cacheA.getAllCategories().size(), (long)2L);
        Assert.assertEquals((long)((Map)cacheA.getAllCategories().get("one")).size(), (long)3L);
        Assert.assertEquals((long)((Map)cacheA.getAllCategories().get("two")).size(), (long)3L);
        PluginCache cacheB = new PluginCache();
        this.createCategory(cacheB, "two", Arrays.asList("bravo", "alpha", "charlie"));
        this.createCategory(cacheB, "one", Arrays.asList("alpha", "charlie", "bravo"));
        Assert.assertEquals((long)cacheB.getAllCategories().size(), (long)2L);
        Assert.assertEquals((long)((Map)cacheB.getAllCategories().get("one")).size(), (long)3L);
        Assert.assertEquals((long)((Map)cacheB.getAllCategories().get("two")).size(), (long)3L);
        Assert.assertArrayEquals((byte[])this.cacheData(cacheA), (byte[])this.cacheData(cacheB));
    }

    private void createCategory(PluginCache cache, String categoryName, List<String> entryNames) {
        Map category = cache.getCategory(categoryName);
        for (String entryName : entryNames) {
            PluginEntry entry = new PluginEntry();
            entry.setKey(entryName);
            entry.setClassName("com.example.Plugin");
            entry.setName("name");
            entry.setCategory(categoryName);
            category.put(entryName, entry);
        }
    }

    private byte[] cacheData(PluginCache cache) throws IOException {
        ByteArrayOutputStream outputB = new ByteArrayOutputStream();
        cache.writeCache((OutputStream)outputB);
        return outputB.toByteArray();
    }
}

