/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.async.AsyncLoggerConfig;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigDisruptor;
import org.apache.logging.log4j.core.async.AsyncWaitStrategyFactory;
import org.apache.logging.log4j.core.async.TimeoutBlockingWaitStrategy;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.experimental.categories.Category;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@Category(value={AsyncLoggers.class})
public class AsyncWaitStrategyFactoryConfigTest {
    @Test
    @LoggerContextSource(value="AsyncWaitStrategyFactoryConfigTest.xml")
    public void testConfigWaitStrategyFactory(LoggerContext context) throws Exception {
        AsyncWaitStrategyFactory asyncWaitStrategyFactory = context.getConfiguration().getAsyncWaitStrategyFactory();
        Assertions.assertEquals(YieldingWaitStrategyFactory.class, asyncWaitStrategyFactory.getClass());
        MatcherAssert.assertThat((String)"factory is YieldingWaitStrategyFactory", (boolean)(asyncWaitStrategyFactory instanceof YieldingWaitStrategyFactory));
    }

    @Test
    @LoggerContextSource(value="AsyncWaitStrategyFactoryConfigTest.xml")
    public void testWaitStrategy(LoggerContext context) throws Exception {
        Logger logger = context.getRootLogger();
        AsyncLoggerConfig loggerConfig = (AsyncLoggerConfig)logger.get();
        AsyncLoggerConfigDisruptor delegate = (AsyncLoggerConfigDisruptor)loggerConfig.getAsyncLoggerConfigDelegate();
        Assertions.assertEquals(YieldingWaitStrategy.class, delegate.getWaitStrategy().getClass());
        MatcherAssert.assertThat((String)"waitstrategy is YieldingWaitStrategy", (boolean)(delegate.getWaitStrategy() instanceof YieldingWaitStrategy));
    }

    @Test
    @LoggerContextSource(value="AsyncWaitStrategyIncorrectFactoryConfigTest.xml")
    public void testIncorrectConfigWaitStrategyFactory(LoggerContext context) throws Exception {
        AsyncWaitStrategyFactory asyncWaitStrategyFactory = context.getConfiguration().getAsyncWaitStrategyFactory();
        Assert.assertNull((Object)asyncWaitStrategyFactory);
    }

    @Test
    @LoggerContextSource(value="AsyncWaitStrategyIncorrectFactoryConfigTest.xml")
    public void testIncorrectWaitStrategyFallsBackToDefault(@Named(value="WaitStrategyAppenderList") ListAppender list1, LoggerContext context) throws Exception {
        Logger logger = context.getRootLogger();
        AsyncLoggerConfig loggerConfig = (AsyncLoggerConfig)logger.get();
        AsyncLoggerConfigDisruptor delegate = (AsyncLoggerConfigDisruptor)loggerConfig.getAsyncLoggerConfigDelegate();
        Assertions.assertEquals(TimeoutBlockingWaitStrategy.class, delegate.getWaitStrategy().getClass());
        MatcherAssert.assertThat((String)"waitstrategy is TimeoutBlockingWaitStrategy", (boolean)(delegate.getWaitStrategy() instanceof TimeoutBlockingWaitStrategy));
    }

    public static class YieldingWaitStrategyFactory
    implements AsyncWaitStrategyFactory {
        public WaitStrategy createWaitStrategy() {
            return new YieldingWaitStrategy();
        }
    }
}

